/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.items;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.GuiHelper;
import squeek.spiceoflife.helpers.InventoryHelper;
import squeek.spiceoflife.helpers.MealPrioritizationHelper;
import squeek.spiceoflife.helpers.MiscHelper;
import squeek.spiceoflife.helpers.MovementHelper;
import squeek.spiceoflife.inventory.FoodContainerInventory;
import squeek.spiceoflife.inventory.INBTInventoryHaver;
import squeek.spiceoflife.inventory.NBTInventory;
import squeek.spiceoflife.network.NetworkHelper;
import squeek.spiceoflife.network.PacketHandler;
import squeek.spiceoflife.network.PacketToggleFoodContainer;

public class ItemFoodContainer
extends Item
implements INBTInventoryHaver,
IEdible {
    public int numSlots;
    public String itemName;
    public static final Random random = new Random();
    public static final String TAG_KEY_INVENTORY = "Inventory";
    public static final String TAG_KEY_OPEN = "Open";
    public static final String TAG_KEY_UUID = "UUID";

    public ItemFoodContainer(String itemName, int numSlots) {
        this.itemName = itemName;
        this.numSlots = numSlots;
        this.func_77625_d(1);
        this.setRegistryName(this.itemName);
        this.func_77655_b("spiceoflife".toLowerCase(Locale.ROOT) + '.' + this.itemName);
        this.func_77637_a(CreativeTabs.field_78026_f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        final ModelResourceLocation closed = new ModelResourceLocation(this.getRegistryName(), "inventory");
        final ModelResourceLocation openEmpty = new ModelResourceLocation(this.getRegistryName() + "_open_empty", "inventory");
        final ModelResourceLocation openFull = new ModelResourceLocation(this.getRegistryName() + "_open_full", "inventory");
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{closed, openEmpty, openFull});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack itemStack) {
                if (ItemFoodContainer.this.isOpen(itemStack)) {
                    return ItemFoodContainer.this.isEmpty(itemStack) ? openEmpty : openFull;
                }
                return closed;
            }
        });
    }

    public boolean isEmpty(@Nonnull ItemStack itemStack) {
        return NBTInventory.isInventoryEmpty(this.getInventoryTag(itemStack));
    }

    public boolean isFull(@Nonnull ItemStack itemStack) {
        return this.getInventory(itemStack).isInventoryFull();
    }

    public boolean isOpen(@Nonnull ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n(TAG_KEY_OPEN);
    }

    public void setIsOpen(@Nonnull ItemStack itemStack, boolean isOpen) {
        NBTTagCompound baseTag = this.getOrInitBaseTag(itemStack);
        baseTag.func_74757_a(TAG_KEY_OPEN, isOpen);
    }

    public UUID getUUID(@Nonnull ItemStack itemStack) {
        return UUID.fromString(this.getOrInitBaseTag(itemStack).func_74779_i(TAG_KEY_UUID));
    }

    public NBTTagCompound getOrInitBaseTag(@Nonnull ItemStack itemStack) {
        NBTTagCompound baseTag;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if ((baseTag = itemStack.func_77978_p()) != null && !baseTag.func_74764_b(TAG_KEY_UUID)) {
            baseTag.func_74778_a(TAG_KEY_UUID, UUID.randomUUID().toString());
        }
        return baseTag;
    }

    public NBTTagCompound getInventoryTag(@Nonnull ItemStack itemStack) {
        NBTTagCompound baseTag = this.getOrInitBaseTag(itemStack);
        if (!baseTag.func_74764_b(TAG_KEY_INVENTORY)) {
            baseTag.func_74782_a(TAG_KEY_INVENTORY, (NBTBase)new NBTTagCompound());
        }
        return baseTag.func_74775_l(TAG_KEY_INVENTORY);
    }

    public FoodContainerInventory getInventory(@Nonnull ItemStack itemStack) {
        return new FoodContainerInventory(this, itemStack);
    }

    public void tryDumpFoodInto(@Nonnull ItemStack itemStack, IItemHandler inventory, EntityPlayer player) {
        FoodContainerInventory foodContainerInventory = this.getInventory(itemStack);
        for (int slotNum = 0; slotNum < foodContainerInventory.func_70302_i_(); ++slotNum) {
            ItemStack stackInSlot = foodContainerInventory.func_70301_a(slotNum);
            if (stackInSlot.func_190926_b()) continue;
            stackInSlot = InventoryHelper.insertStackIntoInventory(stackInSlot, inventory);
            foodContainerInventory.func_70299_a(slotNum, stackInSlot);
        }
    }

    public void tryPullFoodFrom(@Nonnull ItemStack itemStack, IItemHandlerModifiable inventory, EntityPlayer player) {
        List<MealPrioritizationHelper.InventoryFoodInfo> foodsToPull = MealPrioritizationHelper.findBestFoodsForPlayerAccountingForVariety(player, (IItemHandler)inventory);
        if (!foodsToPull.isEmpty()) {
            FoodContainerInventory foodContainerInventory = this.getInventory(itemStack);
            for (MealPrioritizationHelper.InventoryFoodInfo foodToPull : foodsToPull) {
                ItemStack stackInSlot = inventory.getStackInSlot(foodToPull.slotNum);
                if (stackInSlot.func_190926_b()) continue;
                stackInSlot = InventoryHelper.insertStackIntoInventoryOnce(stackInSlot, (IItemHandler)foodContainerInventory.getItemHandler());
                inventory.setStackInSlot(foodToPull.slotNum, stackInSlot);
            }
        }
    }

    public boolean canBeEatenFrom(@Nonnull ItemStack stack) {
        return this.isOpen(stack) && !this.isEmpty(stack);
    }

    public boolean canPlayerEatFrom(EntityPlayer player, @Nonnull ItemStack stack) {
        return this.canBeEatenFrom(stack) && player.func_71043_e(false);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity ownerEntity, int par4, boolean par5) {
        EntityPlayer player;
        if (!world.field_72995_K && ownerEntity instanceof EntityPlayer && this.isOpen(itemStack) && !this.isEmpty(itemStack) && !(player = (EntityPlayer)ownerEntity).func_70093_af() && MovementHelper.getDidJumpLastTick(player)) {
            float chanceToDrop = ModConfig.FOOD_CONTAINERS_CHANCE_TO_DROP_FOOD;
            if (player.func_70051_ag()) {
                chanceToDrop *= 2.0f;
            }
            if (chanceToDrop > 0.0f && random.nextFloat() <= chanceToDrop) {
                ItemStack itemToDrop = InventoryHelper.removeRandomSingleItemFromInventory((IItemHandler)this.getInventory(itemStack).getItemHandler(), random);
                player.func_71019_a(itemToDrop, true);
            }
        }
        super.func_77663_a(itemStack, world, ownerEntity, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> toolTip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, toolTip, tooltipFlag);
        String openCloseLineColor = TextFormatting.GRAY.toString();
        if (this.isOpen(itemStack)) {
            toolTip.add(openCloseLineColor + I18n.func_135052_a((String)"spiceoflife.tooltip.to.close.food.container", (Object[])new Object[0]));
            if (ModConfig.FOOD_CONTAINERS_CHANCE_TO_DROP_FOOD > 0.0f) {
                toolTip.add(TextFormatting.GOLD.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"spiceoflife.tooltip.can.spill.food", (Object[])new Object[0]));
            }
        } else {
            toolTip.add(openCloseLineColor + I18n.func_135052_a((String)"spiceoflife.tooltip.to.open.food.container", (Object[])new Object[0]));
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IItemHandler inventoryHit;
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && this.isOpen(itemStack) && (inventoryHit = InventoryHelper.getInventoryAtLocation(world, pos)) != null && inventoryHit instanceof IItemHandlerModifiable) {
            this.tryDumpFoodInto(itemStack, inventoryHit, player);
            this.tryPullFoodFrom(itemStack, (IItemHandlerModifiable)inventoryHit, player);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack itemStack) {
        if (this.canBeEatenFrom(itemStack)) {
            return EnumAction.EAT;
        }
        return EnumAction.NONE;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setIsOpen(itemStack, !this.isOpen(itemStack));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (this.canPlayerEatFrom(player, itemStack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (!this.isOpen(itemStack) && hand == EnumHand.MAIN_HAND) {
            GuiHelper.openGuiOfItemStack(player, itemStack);
            this.setIsOpen(itemStack, true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving.field_70170_p.field_72995_K && ModConfig.LEFT_CLICK_OPENS_FOOD_CONTAINERS && MiscHelper.isMouseOverNothing()) {
            PacketHandler.channel.sendToServer(new PacketToggleFoodContainer());
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            int slotWithBestFood;
            EntityPlayer player = (EntityPlayer)entityLiving;
            IItemHandlerModifiable inventory = this.getInventory(itemStack).getItemHandler();
            ItemStack foodToEat = inventory.getStackInSlot(slotWithBestFood = MealPrioritizationHelper.findBestFoodForPlayerToEat(player, (IItemHandler)inventory));
            if (!foodToEat.func_190926_b()) {
                ItemStack result = foodToEat.func_77950_b(world, (EntityLivingBase)player);
                if ((result = ForgeEventFactory.onItemUseFinish((EntityLivingBase)player, (ItemStack)foodToEat, (int)32, (ItemStack)result)).func_190926_b() || result.func_190916_E() <= 0) {
                    result = ItemStack.field_190927_a;
                }
                inventory.setStackInSlot(slotWithBestFood, result);
            }
        }
        return super.func_77654_b(itemStack, world, entityLiving);
    }

    public ItemStack getBestFoodForPlayerToEat(ItemStack itemStack, EntityPlayer player) {
        IItemHandlerModifiable inventory = this.getInventory(itemStack).getItemHandler();
        int slotWithBestFood = MealPrioritizationHelper.findBestFoodForPlayerToEat(player, (IItemHandler)inventory);
        return inventory.getStackInSlot(slotWithBestFood);
    }

    @Override
    public int getSizeInventory() {
        return this.numSlots;
    }

    @Override
    public String getInvName(NBTInventory inventory) {
        return this.func_77658_a() + ".name";
    }

    @Override
    public boolean hasCustomName(NBTInventory inventory) {
        return false;
    }

    @Override
    public int getInventoryStackLimit(NBTInventory inventory) {
        return ModConfig.FOOD_CONTAINERS_MAX_STACKSIZE;
    }

    @Override
    public void onInventoryChanged(NBTInventory inventory) {
    }

    @Override
    public boolean isItemValidForSlot(NBTInventory inventory, int slotNum, @Nonnull ItemStack itemStack) {
        return FoodHelper.isFood(itemStack) && FoodHelper.isDirectlyEdible(itemStack);
    }

    public FoodValues getFoodValues(@Nonnull ItemStack itemStack) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return FoodValues.get((ItemStack)this.getBestFoodForPlayerToEat(itemStack, NetworkHelper.getClientPlayer()));
        }
        return new FoodValues(0, 0.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void getFoodValues(FoodEvent.GetFoodValues event) {
        if (FoodHelper.isFoodContainer(event.food)) {
            event.foodValues = event.unmodifiedFoodValues;
        }
    }
}

