/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.FileHelper;
import squeek.spiceoflife.helpers.MiscHelper;

public class FoodGroupConfig {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
    private static File[] configFiles;

    public static void setup(File configDirectory) {
        File modConfigDirectory = new File(configDirectory, "spiceoflife");
        if (modConfigDirectory.exists() || modConfigDirectory.mkdirs()) {
            FoodGroupConfig.writeExampleFoodGroup(modConfigDirectory);
            configFiles = modConfigDirectory.listFiles();
        }
    }

    public static void writeExampleFoodGroup(File configDirectory) {
        String exampleFoodGroupFileName = "example-food-group.json";
        String exampleFoodGroupRelativePath = "example/" + exampleFoodGroupFileName;
        File exampleFoodGroupDest = new File(configDirectory, exampleFoodGroupFileName);
        try {
            boolean shouldOverwrite = FoodGroupConfig.shouldOverwriteExampleFoodGroup(exampleFoodGroupDest);
            if (ModSpiceOfLife.instance.sourceFile != null && ModSpiceOfLife.instance.sourceFile.isDirectory()) {
                File sourceFile = new File(ModSpiceOfLife.instance.sourceFile, exampleFoodGroupRelativePath);
                FileHelper.copyFile(sourceFile, exampleFoodGroupDest, shouldOverwrite);
            } else {
                InputStream exampleFoodGroupInputStream = FoodGroupConfig.class.getClassLoader().getResourceAsStream(exampleFoodGroupRelativePath);
                FileHelper.copyFile(exampleFoodGroupInputStream, exampleFoodGroupDest, shouldOverwrite);
                exampleFoodGroupInputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldOverwriteExampleFoodGroup(File exampleFoodGroup) throws IOException {
        boolean bl;
        FileInputStream exampleFoodGroupStream;
        try {
            exampleFoodGroupStream = new FileInputStream(exampleFoodGroup);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        BufferedReader exampleFoodGroupReader = null;
        try {
            exampleFoodGroupReader = new BufferedReader(new InputStreamReader((InputStream)exampleFoodGroupStream, "UTF8"));
            String firstLine = exampleFoodGroupReader.readLine();
            bl = !"// Mod Version: 1.3.12".equals(firstLine);
        }
        catch (Throwable throwable) {
            MiscHelper.tryCloseStream(exampleFoodGroupReader);
            throw throwable;
        }
        MiscHelper.tryCloseStream(exampleFoodGroupReader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void load() {
        for (File configFile : configFiles) {
            boolean isJson = FilenameUtils.getExtension((String)configFile.getName()).equalsIgnoreCase("json");
            if (!isJson) continue;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF8");
                FoodGroup foodGroup = (FoodGroup)gson.fromJson((Reader)reader, FoodGroup.class);
                if (foodGroup != null && foodGroup.enabled) {
                    foodGroup.identifier = FilenameUtils.removeExtension((String)configFile.getName());
                    foodGroup.initFromConfig();
                    FoodGroupRegistry.addFoodGroup(foodGroup);
                }
                MiscHelper.tryCloseStream(reader);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                MiscHelper.tryCloseStream(reader);
            }
        }
    }
}

