/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util;

import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class InvUtils {
    private InvUtils() {
    }

    public static List<ItemStack> getInvAsList(IItemHandler inv) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack item = inv.getStackInSlot(slot);
            if (item.func_190926_b()) continue;
            output.add(item);
        }
        return output;
    }

    public static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_190916_E() == stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }

    public static int extractWithCount(IItemHandler dest, IItemHandler src, int count) {
        int leftToMove = count;
        for (int i = 0; i < dest.getSlots() && leftToMove > 0; ++i) {
            ItemStack destStack = dest.getStackInSlot(i);
            if (!destStack.func_190926_b() && (!destStack.func_77985_e() || destStack.func_190916_E() >= destStack.func_77976_d())) continue;
            for (int j = 0; j < src.getSlots() && leftToMove > 0; ++j) {
                int toMove;
                ItemStack result;
                ItemStack srcStack = src.getStackInSlot(j);
                if (srcStack.func_190926_b() || !CommonUtils.willItemsStack(destStack, srcStack) || (result = src.extractItem(j, toMove = Math.min(leftToMove, Math.min(srcStack.func_190916_E(), destStack.func_77976_d() - destStack.func_190916_E())), false)).func_190926_b()) continue;
                dest.insertItem(i, result, false);
                leftToMove -= result.func_190916_E();
            }
        }
        return count - leftToMove;
    }
}

