/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.items;

import appeng.api.AEApi;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCell;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellBase;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IEMCStorageChannel;
import com.mordenkainen.equivalentenergistics.items.ItemCellBase;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.api.item.IItemEmc;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEMCCell
extends ItemCellBase
implements IItemEmc {
    private static final String EMC_TAG = "emc";
    private static final double[] CELL_CAPACITIES = new double[]{EqEConfig.cellCapacities.tier1Cell, EqEConfig.cellCapacities.tier2Cell, EqEConfig.cellCapacities.tier3Cell, EqEConfig.cellCapacities.tier4Cell, EqEConfig.cellCapacities.tier5Cell, EqEConfig.cellCapacities.tier6Cell, EqEConfig.cellCapacities.tier7Cell, EqEConfig.cellCapacities.tier8Cell};
    private static final double[] CELL_DRAINS = new double[]{EqEConfig.cellPowerDrain.tier1Cell, EqEConfig.cellPowerDrain.tier2Cell, EqEConfig.cellPowerDrain.tier3Cell, EqEConfig.cellPowerDrain.tier4Cell, EqEConfig.cellPowerDrain.tier5Cell, EqEConfig.cellPowerDrain.tier6Cell, EqEConfig.cellPowerDrain.tier7Cell, EqEConfig.cellPowerDrain.tier8Cell};

    public ItemEMCCell() {
        super("emc_cell", 8);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.values()[stack.func_77960_j() / 2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"message.cell.capacity", (Object[])new Object[0]) + " " + CommonUtils.formatEMC(this.getMaximumEmc(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player != null && this.isEmpty(player.func_184586_b(hand)) && player.func_70093_af() && player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.MISC, 1, 0))) {
            return new ActionResult(EnumActionResult.PASS, (Object)new ItemStack((Item)ModItems.COMPONENT, 1, player.func_184586_b(hand).func_77952_i()));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public <T extends IAEStack<T>> ICellInventoryHandler<T> getCellInventory(ItemStack stack, ISaveProvider host, IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class) && this.isCell(stack)) {
            return new HandlerEMCCell(stack, host, CELL_CAPACITIES[stack.func_77952_i()]);
        }
        return null;
    }

    public <T extends IAEStack<T>> int getStatusForCell(ItemStack stack, ICellInventoryHandler<T> handler) {
        return handler instanceof HandlerEMCCellBase ? ((HandlerEMCCellBase)handler).getCellStatus() : 0;
    }

    public <T extends IAEStack<T>> double cellIdleDrain(ItemStack stack, ICellInventoryHandler<T> handler) {
        return CELL_DRAINS[stack.func_77952_i()];
    }

    public double getStoredCellEMC(ItemStack stack) {
        if (!this.isCell(stack) || !this.hasEMCTag(stack)) {
            return 0.0;
        }
        return Math.max(stack.func_77978_p().func_74769_h(EMC_TAG), 0.0);
    }

    public double addEmc(ItemStack stack, double toAdd) {
        double currentEMC = this.getStoredCellEMC(stack);
        double amountToAdd = Math.min(toAdd, CELL_CAPACITIES[stack.func_77952_i()] - currentEMC);
        if (amountToAdd > 0.0) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74780_a(EMC_TAG, currentEMC + amountToAdd);
        }
        return amountToAdd;
    }

    public double extractEmc(ItemStack stack, double emc) {
        double currentEMC = this.getStoredCellEMC(stack);
        double toRemove = Math.min(emc, currentEMC);
        if (this.hasEMCTag(stack)) {
            stack.func_77978_p().func_74780_a(EMC_TAG, currentEMC - toRemove);
            if (this.isEmpty(stack)) {
                this.removeEMCTag(stack);
            }
        }
        return toRemove;
    }

    public double getStoredEmc(ItemStack stack) {
        return this.getStoredCellEMC(stack);
    }

    public double getMaximumEmc(ItemStack stack) {
        return CELL_CAPACITIES[stack.func_77952_i()];
    }

    private void removeEMCTag(ItemStack stack) {
        stack.func_77978_p().func_82580_o(EMC_TAG);
        if (stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    private boolean hasEMCTag(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(EMC_TAG);
    }

    private boolean isEmpty(ItemStack stack) {
        return this.getStoredCellEMC(stack) == 0.0;
    }
}

