/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.tiles;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.util.DimensionalCoord;
import com.mordenkainen.equivalentenergistics.blocks.base.tile.EqETileBase;
import com.mordenkainen.equivalentenergistics.integration.ae2.MachineSource;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.AEProxy;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridAccessException;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.IAEProxyHost;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TileAEBase
extends EqETileBase
implements IAEProxyHost {
    private static final String POWERED_TAG = "powered";
    private static final String ACTIVE_TAG = "active";
    protected final AEProxy gridProxy;
    protected IActionSource mySource = new MachineSource(this);
    protected boolean active;
    protected boolean powered;

    public TileAEBase(ItemStack repItem) {
        this.gridProxy = new AEProxy(this, "node0", repItem, true);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        IAEProxyHost.super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        IAEProxyHost.super.invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        IAEProxyHost.super.validate();
    }

    @Override
    public void onReady() {
        IAEProxyHost.super.onReady();
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        IAEProxyHost.super.readFromNBT(data);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        IAEProxyHost.super.writeToNBT(data);
        return data;
    }

    @Override
    public AEProxy getProxy() {
        return this.gridProxy;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void securityBreak() {
        CommonUtils.destroyAndDrop(this.func_145831_w(), this.field_174879_c);
    }

    protected boolean checkPermissions(EntityPlayer player) {
        try {
            ISecurityGrid sGrid = GridUtils.getSecurity(this.getProxy());
            return sGrid.hasPermission(player, SecurityPermissions.INJECT) && sGrid.hasPermission(player, SecurityPermissions.EXTRACT) && sGrid.hasPermission(player, SecurityPermissions.BUILD);
        }
        catch (GridAccessException e) {
            CommonUtils.debugLog("TileAEBase:checkPermissions: Error accessing grid:", e);
            return true;
        }
    }

    public boolean isActive() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return this.active;
        }
        return this.gridProxy.isReady() && this.gridProxy.isActive();
    }

    public boolean isPowered() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return this.powered;
        }
        return this.gridProxy.isReady() && this.gridProxy.isPowered();
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a(POWERED_TAG, this.isPowered());
        nbttagcompound.func_74757_a(ACTIVE_TAG, this.isActive());
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        boolean flag = false;
        boolean newState = nbttagcompound.func_74767_n(POWERED_TAG);
        if (newState != this.powered) {
            this.powered = newState;
            flag = true;
        }
        if ((newState = nbttagcompound.func_74767_n(ACTIVE_TAG)) != this.active) {
            this.active = newState;
            flag = true;
        }
        return flag;
    }

    protected boolean refreshNetworkState() {
        boolean flag = false;
        boolean newState = this.isPowered();
        if (newState != this.powered) {
            this.powered = newState;
            flag = true;
        }
        if ((newState = this.isActive()) != this.active) {
            this.active = newState;
            flag = true;
        }
        return flag;
    }
}

