/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import com.google.common.base.Preconditions;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IAEEMCStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IEMCStorageChannel;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AEEMCStack
implements IAEEMCStack {
    private long emcValue;

    public AEEMCStack(double emcValue) {
        this.emcValue = (long)(emcValue * 1000.0);
    }

    public AEEMCStack(IAEEMCStack input) {
        Preconditions.checkNotNull((Object)input);
        this.emcValue = input.getStackSize();
    }

    public void add(IAEEMCStack stack) {
        if (stack == null) {
            return;
        }
        this.incStackSize(stack.getStackSize());
    }

    public ItemStack asItemStackRepresentation() {
        return new ItemStack((Item)ModItems.CRYSTAL, 1, 2);
    }

    public IAEEMCStack copy() {
        return new AEEMCStack(this);
    }

    public void decCountRequestable(long amount) {
    }

    public void decStackSize(long amount) {
        this.emcValue -= amount;
    }

    public IAEEMCStack empty() {
        IAEEMCStack dup = this.copy();
        dup.reset();
        return dup;
    }

    public boolean fuzzyComparison(IAEEMCStack arg0, FuzzyMode arg1) {
        return false;
    }

    public IStorageChannel<IAEEMCStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class);
    }

    public long getCountRequestable() {
        return 0L;
    }

    public long getStackSize() {
        return this.emcValue;
    }

    public void incCountRequestable(long amount) {
    }

    public void incStackSize(long amount) {
        this.emcValue += amount;
    }

    public boolean isCraftable() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isMeaningful() {
        return true;
    }

    public IAEEMCStack reset() {
        this.emcValue = 0L;
        return this;
    }

    public IAEEMCStack setCountRequestable(long countRequestable) {
        return this;
    }

    public IAEEMCStack setCraftable(boolean isCraftable) {
        return this;
    }

    public IAEEMCStack setStackSize(long size) {
        this.emcValue = size;
        return this;
    }

    public void writeToNBT(NBTTagCompound arg0) {
        arg0.func_74772_a("size", this.emcValue);
    }

    public void writeToPacket(ByteBuf buff) throws IOException {
        buff.writeLong(this.emcValue);
    }

    @Override
    public double getEMCValue() {
        return (double)this.emcValue / 1000.0;
    }

    public static AEEMCStack fromPacket(ByteBuf data) {
        return new AEEMCStack(data.readLong());
    }

    public static AEEMCStack fromNBT(NBTTagCompound arg0) {
        return new AEEMCStack(arg0.func_74763_f("size"));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.emcValue ^ this.emcValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof AEEMCStack;
    }
}

