/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cells;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellBase;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IAEEMCStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.storagechannel.IEMCStorageChannel;
import com.mordenkainen.equivalentenergistics.util.EMCPool;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HandlerEMCCell
extends HandlerEMCCellBase {
    private static final String EMC_TAG = "emc";
    private final NBTTagCompound cellData;
    private final EMCPool pool = new EMCPool();

    public HandlerEMCCell(ItemStack storageStack, ISaveProvider saveProvider, double cellCapacities) {
        super(saveProvider);
        if (!storageStack.func_77942_o()) {
            storageStack.func_77982_d(new NBTTagCompound());
        }
        this.pool.setMaxEMC(cellCapacities);
        this.cellData = storageStack.func_77978_p();
        if (this.cellData.func_74764_b(EMC_TAG)) {
            this.pool.setCurrentEMC(this.cellData.func_74763_f(EMC_TAG));
        }
    }

    @Override
    public int getCellStatus() {
        if (this.pool.getCurrentEMC() >= this.pool.getMaxEMC()) {
            return 3;
        }
        if (this.pool.getCurrentEMC() >= this.pool.getMaxEMC() * 0.75) {
            return 2;
        }
        return 1;
    }

    private void updateEMC() {
        this.cellData.func_74780_a(EMC_TAG, this.pool.getCurrentEMC());
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges(null);
        }
    }

    public IAEEMCStack extractItems(IAEEMCStack request, Actionable mode, IActionSource src) {
        if (request == null) {
            return null;
        }
        double toExtract = Math.min(this.pool.getCurrentEMC(), request.getEMCValue());
        if (mode == Actionable.MODULATE) {
            this.pool.extractEMC(toExtract);
            this.updateEMC();
        }
        if (toExtract > 0.0) {
            IAEEMCStack extracted = (IAEEMCStack)request.copy();
            extracted.setStackSize((long)(toExtract * 1000.0));
            return extracted;
        }
        return null;
    }

    public IItemList<IAEEMCStack> getAvailableItems(IItemList<IAEEMCStack> stacks) {
        if (this.pool.getCurrentEMC() > 0.0) {
            IAEEMCStack current = (IAEEMCStack)((IEMCStorageChannel)AEApi.instance().storage().getStorageChannel(IEMCStorageChannel.class)).createStack(this.pool.getCurrentEMC());
            stacks.add((IAEStack)current);
        }
        return stacks;
    }

    public IAEEMCStack injectItems(IAEEMCStack input, Actionable mode, IActionSource src) {
        if (input == null || input.getStackSize() == 0L) {
            return null;
        }
        double toStore = Math.min(input.getEMCValue(), this.pool.getAvail());
        if (mode == Actionable.MODULATE) {
            this.pool.addEMC(toStore);
            this.updateEMC();
        }
        if (toStore >= input.getEMCValue()) {
            return null;
        }
        IAEEMCStack remainder = (IAEEMCStack)input.copy();
        remainder.setStackSize(input.getStackSize() - (long)(toStore * 1000.0));
        return remainder;
    }
}

