/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import com.google.common.base.Equivalence;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.integration.ae2.EMCCraftingPattern;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.IEMCCraftingGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.ITransProvider;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import com.mordenkainen.equivalentenergistics.util.CompItemStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EMCCraftingGrid
implements IEMCCraftingGrid {
    private static Equivalence<ItemStack> eq = new CompItemStack();
    private static Map<Equivalence.Wrapper<ItemStack>, EMCCraftingPattern> patternList = new HashMap<Equivalence.Wrapper<ItemStack>, EMCCraftingPattern>();
    private static int patternVer;
    private static Map<EMCCraftingGrid, Boolean> craftingGrids;
    private final IGrid grid;
    private final Map<Equivalence.Wrapper<ItemStack>, EMCCraftingPattern> patterns = new HashMap<Equivalence.Wrapper<ItemStack>, EMCCraftingPattern>();
    private final Map<ITransProvider, String> patternProviders = new WeakHashMap<ITransProvider, String>();
    private int lastPatternVer = -1;

    public EMCCraftingGrid(IGrid grid) {
        this.grid = grid;
        craftingGrids.put(this, true);
    }

    public void onUpdateTick() {
        if (this.lastPatternVer != patternVer) {
            this.updatePatterns();
            this.lastPatternVer = patternVer;
        }
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ITransProvider) {
            this.patternProviders.remove((ITransProvider)machine);
            if (!((ITransProvider)machine).getTransmutations().isEmpty()) {
                this.lastPatternVer = -1;
            }
        }
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ITransProvider) {
            this.patternProviders.put((ITransProvider)machine, ((ITransProvider)machine).getPlayerUUID());
            if (!((ITransProvider)machine).getTransmutations().isEmpty()) {
                this.lastPatternVer = -1;
            }
        }
    }

    @Override
    public void updatePatterns() {
        this.patterns.clear();
        this.addCrystalPatterns();
        for (ITransProvider provider : this.patternProviders.keySet()) {
            this.patternProviders.put(provider, provider.getPlayerUUID());
            for (ItemStack stack : provider.getTransmutations()) {
                this.addPattern(stack);
            }
        }
        this.grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange(null, null));
    }

    private void addPattern(ItemStack stack) {
        Equivalence.Wrapper wrappedStack = eq.wrap((Object)stack);
        EMCCraftingGrid.createPattern((Equivalence.Wrapper<ItemStack>)wrappedStack);
        if (patternList.containsKey(wrappedStack)) {
            this.patterns.put((Equivalence.Wrapper<ItemStack>)wrappedStack, patternList.get(wrappedStack));
        }
    }

    private void addCrystalPatterns() {
        for (int i = 0; i < 4; ++i) {
            Equivalence.Wrapper wrappedStack = eq.wrap((Object)new ItemStack((Item)ModItems.CRYSTAL, 64, i));
            if (!patternList.containsKey(wrappedStack)) {
                patternList.put((Equivalence.Wrapper<ItemStack>)wrappedStack, new EMCCraftingPattern((ItemStack)wrappedStack.get()));
            }
            this.patterns.put((Equivalence.Wrapper<ItemStack>)wrappedStack, patternList.get(wrappedStack));
        }
    }

    private void postKnowledgeEvent(UUID playerUUID) {
        if (this.patternProviders.values().contains(playerUUID.toString())) {
            this.lastPatternVer = -1;
        }
    }

    @Override
    public EMCCraftingPattern[] getPatterns() {
        return this.patterns.isEmpty() ? new EMCCraftingPattern[]{} : this.patterns.values().toArray(new EMCCraftingPattern[0]);
    }

    public static void energyEvent() {
        Iterator<Equivalence.Wrapper<ItemStack>> iter = patternList.keySet().iterator();
        while (iter.hasNext()) {
            Equivalence.Wrapper<ItemStack> wrappedStack = iter.next();
            if (ProjectEAPI.getEMCProxy().getValue((ItemStack)wrappedStack.get()) > 0L) {
                EMCCraftingPattern pattern = patternList.get(wrappedStack);
                pattern.rebuildPattern();
                if (pattern.valid) continue;
                EquivalentEnergistics.logger.warn("Invalid EMC pattern detected. Item: " + I18n.func_135052_a((String)(pattern.getOutputs()[0].getItem().func_77667_c(pattern.getOutputs()[0].createItemStack()) + ".name"), (Object[])new Object[0]) + " EMC: " + String.format("%f", pattern.outputEMC));
                iter.remove();
                continue;
            }
            iter.remove();
        }
        ++patternVer;
    }

    public static final void knowledgeEvent(UUID playerUUID) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            for (EMCCraftingGrid craftingGrid : craftingGrids.keySet()) {
                craftingGrid.postKnowledgeEvent(playerUUID);
            }
        }
    }

    public static EMCCraftingPattern getPattern(ItemStack stack) {
        Equivalence.Wrapper wrappedStack = eq.wrap((Object)stack);
        EMCCraftingGrid.createPattern((Equivalence.Wrapper<ItemStack>)wrappedStack);
        if (patternList.containsKey(wrappedStack)) {
            return patternList.get(wrappedStack);
        }
        return null;
    }

    private static void createPattern(Equivalence.Wrapper<ItemStack> wrappedStack) {
        if (!patternList.containsKey(wrappedStack)) {
            EMCCraftingPattern pattern = new EMCCraftingPattern((ItemStack)wrappedStack.get());
            if (pattern.valid) {
                patternList.put(wrappedStack, new EMCCraftingPattern((ItemStack)wrappedStack.get()));
            } else {
                EquivalentEnergistics.logger.warn("Invalid EMC pattern detected. Item: " + I18n.func_135052_a((String)(pattern.getOutputs()[0].getItem().func_77667_c(pattern.getOutputs()[0].createItemStack()) + ".name"), (Object[])new Object[0]) + " EMC: " + String.format("%f", pattern.outputEMC));
            }
        }
    }

    static {
        craftingGrids = new WeakHashMap<EMCCraftingGrid, Boolean>();
    }
}

