/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCrystal;
import com.mordenkainen.equivalentenergistics.items.ItemPattern;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import java.util.ArrayList;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class EMCCraftingPattern
implements ICraftingPatternDetails {
    private IAEItemStack[] ingredients;
    private final IAEItemStack[] result = new IAEItemStack[1];
    public double outputEMC;
    public double inputEMC;
    public boolean valid = true;
    private final IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);

    public EMCCraftingPattern(ItemStack craftingResult) {
        this.buildPattern(craftingResult);
    }

    public ItemStack getPattern() {
        return ItemPattern.getItemForPattern(this.result[0].createItemStack());
    }

    public boolean isValidItemForSlot(int slot, ItemStack stack, World world) {
        return false;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return (IAEItemStack[])this.ingredients.clone();
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.getInputs();
    }

    public ItemStack getOutput(InventoryCrafting crafting, World world) {
        return null;
    }

    public IAEItemStack[] getOutputs() {
        return (IAEItemStack[])this.result.clone();
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.getOutputs();
    }

    public boolean canSubstitute() {
        return false;
    }

    public int getPriority() {
        return -1;
    }

    public void setPriority(int priority) {
    }

    private void buildPattern(ItemStack craftingResult) {
        if (craftingResult.func_77973_b() == ModItems.CRYSTAL) {
            this.createCrystalPattern(craftingResult.func_77952_i());
        } else {
            this.createItemPattern(craftingResult);
        }
    }

    public void rebuildPattern() {
        this.buildPattern(this.result[0].createItemStack());
    }

    private void createCrystalPattern(int tier) {
        this.valid = true;
        this.outputEMC = this.inputEMC = ItemEMCCrystal.CRYSTAL_VALUES[tier + 1];
        this.result[0] = (IAEItemStack)this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.CRYSTAL, 64, tier));
        this.ingredients = new IAEItemStack[]{(IAEItemStack)this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.CRYSTAL, 1, tier + 1))};
    }

    private void createItemPattern(ItemStack craftingResult) {
        int stackSize = 1;
        long singleItemValue = ProjectEAPI.getEMCProxy().getValue(ItemHandlerHelper.copyStackWithSize((ItemStack)craftingResult, (int)1));
        if ((double)singleItemValue <= EqEConfig.emcAssembler.maxStackEMC) {
            stackSize = (int)Math.min(64.0, EqEConfig.emcAssembler.maxStackEMC / (double)singleItemValue);
        }
        this.result[0] = (IAEItemStack)((IAEItemStack)this.storageChannel.createStack((Object)craftingResult)).setStackSize((long)stackSize);
        double remainingEMC = this.outputEMC = (double)(singleItemValue * (long)stackSize);
        this.inputEMC = 0.0;
        this.valid = false;
        ArrayList<IAEStack> crystals = new ArrayList<IAEStack>();
        for (int x = 4; x >= 0 && remainingEMC > 0.0; --x) {
            double crystalEMC = ItemEMCCrystal.CRYSTAL_VALUES[x];
            int numCrystals = (int)(remainingEMC / crystalEMC);
            while (numCrystals > 0) {
                crystals.add(((IAEItemStack)this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.CRYSTAL, 1, x))).setStackSize((long)numCrystals));
                double totalEMC = crystalEMC * (double)numCrystals;
                this.inputEMC += totalEMC;
                numCrystals = (int)((remainingEMC -= totalEMC) / crystalEMC);
            }
        }
        if (remainingEMC > 0.0) {
            if (!crystals.isEmpty() && ((IAEItemStack)crystals.get(crystals.size() - 1)).getItemDamage() == 0) {
                ((IAEItemStack)crystals.get(crystals.size() - 1)).setStackSize(((IAEItemStack)crystals.get(crystals.size() - 1)).getStackSize() + 1L);
            } else {
                crystals.add(this.storageChannel.createStack((Object)new ItemStack((Item)ModItems.CRYSTAL, 1, 0)));
            }
            this.inputEMC += 1.0;
        }
        this.ingredients = crystals.toArray(new IAEItemStack[crystals.size()]);
        if (crystals.size() <= 9) {
            this.valid = true;
        }
    }
}

