/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.core.config;

import net.minecraftforge.common.config.Config;

@Config(modid="equivalentenergistics", name="equivalentenergistics")
public final class EqEConfig {
    public static MiscSettings misc = new MiscSettings();
    public static EMCAssembler emcAssembler = new EMCAssembler();
    public static EMCCondenser emcCondenser = new EMCCondenser();
    @Config.Comment(value={"EMC Cell capacities."})
    public static EMCCellCaps cellCapacities = new EMCCellCaps();
    @Config.Comment(value={"EMC Cell power drain."})
    public static EMCCellDrain cellPowerDrain = new EMCCellDrain();

    private EqEConfig() {
    }

    public static class EMCCellDrain {
        public double tier1Cell = 0.1;
        public double tier2Cell = 0.2;
        public double tier3Cell = 0.4;
        public double tier4Cell = 0.8;
        public double tier5Cell = 1.6;
        public double tier6Cell = 3.2;
        public double tier7Cell = 6.4;
        public double tier8Cell = 12.8;
    }

    public static class EMCCellCaps {
        public double creativeCell = 1.6384E10;
        public double tier1Cell = 1000000.0;
        public double tier2Cell = 4000000.0;
        public double tier3Cell = 1.6E7;
        public double tier4Cell = 6.4E7;
        public double tier5Cell = 2.56E8;
        public double tier6Cell = 1.024E9;
        public double tier7Cell = 4.096E9;
        public double tier8Cell = 1.6384E10;
    }

    public static class EMCCondenser {
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The amount of power the EMC Condenser will consume while sitting idle in AE."})
        public double idlePower;
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The amount of power the EMC Condenser will consume per EMC condensed in AE."})
        public double powerPerEMC = 0.01;
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The amount of EMC the basic EMC Condenser can convert per tick. This value is scaled by x10 for each tier of Condenser."})
        public double emcPerTick = 8192.0;
    }

    public static class EMCAssembler {
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The minimum amount of EMC the EMC Assembler will attempt to use. Any items that have an EMC value less than this will craft in stacks of up to this value."})
        public double maxStackEMC = 131072.0;
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The amount of power the EMC Assembler will consume while sitting idle in AE."})
        public double idlePower;
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        @Config.Comment(value={"The amount of power the EMC Assembler will consume per EMC of items crafted in AE."})
        public double powerPerEMC = 0.01;
        @Config.RangeInt(min=0, max=256)
        @Config.Comment(value={"Number of ticks it takes the basic EMC Assembler to craft an item."})
        public int craftingTime = 20;
    }

    public static class MiscSettings {
        @Config.Comment(value={"Enable debug logging."})
        public boolean debug;
    }
}

