/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.core;

import com.mordenkainen.equivalentenergistics.blocks.ModBlocks;
import com.mordenkainen.equivalentenergistics.blocks.base.tile.EqETileBase;
import com.mordenkainen.equivalentenergistics.integration.Integration;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.crafting.EMCCraftingGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.IAEProxyHost;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import java.util.Deque;
import java.util.LinkedList;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="equivalentenergistics")
public final class EventHandler {
    private static final Deque<EqETileBase> TILES = new LinkedList<EqETileBase>();

    private EventHandler() {
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModItems.registerModels();
        ModBlocks.registerModels();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    public static void addInit(EqETileBase tile) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TILES.add(tile);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load load) {
        for (Object te : load.getChunk().func_177434_r().values()) {
            if (!(te instanceof IAEProxyHost)) continue;
            ((EqETileBase)((Object)te)).onChunkLoad();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent ev) {
        if (ev.type == TickEvent.Type.SERVER && ev.phase == TickEvent.Phase.END) {
            while (!TILES.isEmpty()) {
                EqETileBase tile = TILES.poll();
                if (tile.func_145837_r()) continue;
                tile.onReady();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        Integration.worldLoad();
    }

    @SubscribeEvent
    public static void onPlayerKnowledgeChange(PlayerKnowledgeChangeEvent event) {
        EMCCraftingGrid.knowledgeEvent(event.getPlayerUUID());
    }

    @SubscribeEvent
    public static void onEnergyValueChange(EMCRemapEvent event) {
        EMCCraftingGrid.energyEvent();
    }
}

