/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.crafter.tiles;

import appeng.api.networking.security.IActionSource;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.CraftingJob;
import com.mordenkainen.equivalentenergistics.blocks.crafter.tiles.ICraftingMonitor;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.AEProxy;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingManager {
    private static final String TICK_TAG = "RemainingTicks";
    private static final String POWER_TAG = "PowerPerTick";
    private static final String JOB_TAG = "Job";
    private final double craftingTime;
    private final int maxJobs;
    private final ICraftingMonitor monitor;
    private final CraftingJob[] jobs;
    private final AEProxy proxy;
    private final IActionSource source;

    public CraftingManager(double craftingTime, int maxJobs, ICraftingMonitor monitor, AEProxy proxy, IActionSource source) {
        this.craftingTime = craftingTime;
        this.maxJobs = maxJobs;
        this.monitor = monitor;
        this.proxy = proxy;
        this.source = source;
        this.jobs = new CraftingJob[maxJobs];
    }

    public boolean isBusy() {
        for (int i = 0; i < this.maxJobs; ++i) {
            if (this.jobs[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isCrafting() {
        for (int i = 0; i < this.maxJobs; ++i) {
            if (this.jobs[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean addJob(ItemStack outputStack, double emc, double powerPerEMC) {
        if (!this.isBusy()) {
            for (int i = 0; i < this.maxJobs; ++i) {
                if (this.jobs[i] != null) continue;
                this.jobs[i] = new CraftingJob(outputStack.func_77973_b() == ModItems.CRYSTAL ? 0.0 : this.craftingTime, outputStack, emc / this.craftingTime * powerPerEMC, this.proxy, this.source);
                return true;
            }
        }
        return false;
    }

    public boolean craftingTick() {
        for (int i = 0; i < this.maxJobs; ++i) {
            if (this.jobs[i] == null) continue;
            if (!this.jobs[i].craftingTick()) {
                return false;
            }
            if (!this.jobs[i].isFinished()) continue;
            ItemStack output = this.jobs[i].getOutput();
            this.jobs[i] = null;
            this.monitor.craftingFinished(output);
        }
        return true;
    }

    public NonNullList<ItemStack> getCurrentJobs() {
        NonNullList result = NonNullList.func_191197_a((int)this.maxJobs, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.jobs.length; ++i) {
            ItemStack outputStack = null;
            outputStack = this.jobs[i] == null ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)this.jobs[i].getOutput().func_77946_l(), (int)1);
            result.set(i, (Object)outputStack);
        }
        return result;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.jobs.length; ++i) {
            CraftingJob job = this.jobs[i];
            if (job == null) continue;
            NBTTagCompound itemStack = new NBTTagCompound();
            job.getOutput().func_77955_b(itemStack);
            itemStack.func_74780_a(TICK_TAG, job.getRemainingTicks());
            itemStack.func_74780_a(POWER_TAG, job.getCost());
            tag.func_74782_a(JOB_TAG + i, (NBTBase)itemStack);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.maxJobs; ++i) {
            ItemStack outputStack;
            this.jobs[i] = tag.func_74764_b(JOB_TAG + i) ? new CraftingJob((outputStack = new ItemStack((NBTTagCompound)tag.func_74781_a(JOB_TAG + i))).func_77973_b() == ModItems.CRYSTAL ? 0.0 : tag.func_74769_h(TICK_TAG), outputStack, tag.func_74769_h(POWER_TAG), this.proxy, this.source) : null;
        }
    }
}

