/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser.tiles;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import com.mordenkainen.equivalentenergistics.blocks.ModBlocks;
import com.mordenkainen.equivalentenergistics.blocks.condenser.CondenserState;
import com.mordenkainen.equivalentenergistics.blocks.condenser.tiles.TileEMCCondenserAdv;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import com.mordenkainen.equivalentenergistics.util.InvUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEMCCondenserExt
extends TileEMCCondenserAdv {
    private static final String SIDE_TAG = "sides";
    private final Map<EnumFacing, SideSetting> sides = new HashMap<EnumFacing, SideSetting>();

    public TileEMCCondenserExt() {
        this(new ItemStack(Item.func_150898_a((Block)ModBlocks.CONDENSER), 1, 2));
    }

    public TileEMCCondenserExt(ItemStack repItem) {
        super(repItem);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.sides.put(side, SideSetting.NONE);
        }
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        if (this.isActive()) {
            if (this.func_145831_w().func_175687_A(this.field_174879_c) > 0) {
                this.updateState(CondenserState.IDLE);
                return TickRateModulation.IDLE;
            }
            this.importItems();
        }
        return super.tickingRequest(node, ticksSinceLast);
    }

    protected void importItems() {
        int numItems = this.itemsToTransfer();
        for (EnumFacing side : this.sides.keySet()) {
            if (this.sides.get(side) != SideSetting.INPUT) continue;
            TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
            if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) {
                IItemHandler tileInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
                numItems -= InvUtils.extractWithCount((IItemHandler)this.inv, tileInv, numItems);
            }
            if (numItems > 0) continue;
            break;
        }
    }

    @Override
    protected double getEMCPerTick() {
        return EqEConfig.emcCondenser.emcPerTick * 100.0;
    }

    @Override
    protected ItemStack ejectItem(ItemStack stack) {
        IItemHandler tileInv;
        TileEntity tile;
        EnumFacing side;
        if (stack.func_190926_b()) {
            return stack;
        }
        int numItems = Math.min(this.itemsToTransfer(), stack.func_190916_E());
        int overflow = stack.func_190916_E() - numItems;
        ItemStack toStore = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)numItems);
        Iterator<EnumFacing> iterator = this.sides.keySet().iterator();
        while (!(!iterator.hasNext() || this.sides.get(side = iterator.next()) == SideSetting.OUTPUT && (tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()) && (toStore = ItemHandlerHelper.insertItemStacked((IItemHandler)(tileInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())), (ItemStack)toStore, (boolean)false)).func_190926_b())) {
        }
        if (overflow > 0) {
            toStore.func_190917_f(overflow);
        }
        return toStore.func_190926_b() ? toStore : super.ejectItem(toStore);
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        NBTTagCompound list = new NBTTagCompound();
        for (EnumFacing side : this.sides.keySet()) {
            list.func_74768_a(side.name(), this.sides.get(side).ordinal());
        }
        nbttagcompound.func_74782_a(SIDE_TAG, (NBTBase)list);
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        boolean flag = super.readPacketData(nbttagcompound);
        NBTTagCompound list = (NBTTagCompound)nbttagcompound.func_74781_a(SIDE_TAG);
        for (EnumFacing side : this.sides.keySet()) {
            SideSetting newData = SideSetting.values()[list.func_74762_e(side.name())];
            if (newData == this.sides.get(side)) continue;
            this.sides.put(side, newData);
            flag = true;
        }
        return flag;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        NBTTagCompound list = (NBTTagCompound)data.func_74781_a(SIDE_TAG);
        if (list != null) {
            for (EnumFacing side : this.sides.keySet()) {
                this.sides.put(side, SideSetting.values()[list.func_74762_e(side.name())]);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        NBTTagCompound list = new NBTTagCompound();
        for (EnumFacing side : this.sides.keySet()) {
            list.func_74768_a(side.name(), this.sides.get(side).ordinal());
        }
        data.func_74782_a(SIDE_TAG, (NBTBase)list);
        return data;
    }

    public void toggleSide(EnumFacing side) {
        this.sides.put(side, this.sides.get(side).getNext());
        this.markForUpdate();
    }

    public SideSetting getSide(EnumFacing side) {
        return this.sides.get(side);
    }

    protected int itemsToTransfer() {
        return 16;
    }

    @Override
    protected boolean isValidItem(ItemStack stack) {
        return true;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public static enum SideSetting {
        NONE,
        INPUT,
        OUTPUT;


        public SideSetting getNext() {
            int setting = this.ordinal() + 1;
            if (setting >= 3) {
                setting = 0;
            }
            return SideSetting.values()[setting];
        }
    }
}

