/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.blocks.condenser.tiles;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import com.mordenkainen.equivalentenergistics.blocks.ModBlocks;
import com.mordenkainen.equivalentenergistics.blocks.condenser.CondenserState;
import com.mordenkainen.equivalentenergistics.core.config.EqEConfig;
import com.mordenkainen.equivalentenergistics.integration.ae2.grid.GridUtils;
import com.mordenkainen.equivalentenergistics.integration.ae2.tiles.TileAEBase;
import com.mordenkainen.equivalentenergistics.items.ModItems;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import com.mordenkainen.equivalentenergistics.util.IDropItems;
import com.mordenkainen.equivalentenergistics.util.InvUtils;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.item.IItemEmc;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEMCCondenser
extends TileAEBase
implements IGridTickable,
IDropItems {
    private static final String STATE_TAG = "state";
    protected CondenserState state = CondenserState.IDLE;
    protected CondenserInventoryHandler inv = this.createInv();
    private boolean doDrops = true;

    public TileEMCCondenser() {
        this(new ItemStack(Item.func_150898_a((Block)ModBlocks.CONDENSER), 1, 0));
    }

    public TileEMCCondenser(ItemStack stack) {
        super(stack);
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.gridProxy.setIdlePowerUsage(EqEConfig.emcCondenser.idlePower);
    }

    @Override
    protected void getPacketData(NBTTagCompound nbttagcompound) {
        super.getPacketData(nbttagcompound);
        nbttagcompound.func_74768_a(STATE_TAG, this.state.ordinal());
    }

    @Override
    protected boolean readPacketData(NBTTagCompound nbttagcompound) {
        boolean flag = super.readPacketData(nbttagcompound);
        CondenserState newState = CondenserState.values()[nbttagcompound.func_74762_e(STATE_TAG)];
        if (!newState.equals((Object)this.state)) {
            this.state = newState;
            flag = true;
        }
        return flag;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLast) {
        if (this.refreshNetworkState()) {
            this.markForUpdate();
        }
        CondenserState newState = this.state;
        if (!this.isActive() || this.inv.isEmpty()) {
            this.updateState(CondenserState.IDLE);
        } else {
            newState = this.processInv();
            this.updateState(newState);
        }
        return this.state.getTickRate();
    }

    @Override
    public void disableDrops() {
        this.doDrops = false;
    }

    @Override
    public void getDrops(World world, BlockPos pos, List<ItemStack> drops) {
        if (this.doDrops) {
            drops.addAll(InvUtils.getInvAsList((IItemHandler)this.inv));
        }
    }

    protected double getEMCPerTick() {
        return EqEConfig.emcCondenser.emcPerTick;
    }

    public CondenserState getState() {
        return this.state;
    }

    protected int getMaxItemsForPower(int stackSize, double emcValue) {
        double powerPerItem = emcValue * EqEConfig.emcCondenser.powerPerEMC;
        double powerRequired = (double)stackSize * powerPerItem;
        double powerAvail = GridUtils.extractAEPower(this.getProxy(), powerRequired, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        return (int)(powerAvail / powerPerItem);
    }

    protected double processItems(int slot, double remainingEMC, boolean usePower) {
        ItemStack stack = this.inv.getStackInSlot(slot);
        long itemEMC = ProjectEAPI.getEMCProxy().getValue(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        if ((double)itemEMC > remainingEMC) {
            return remainingEMC;
        }
        int numToStore = (int)Math.min((double)stack.func_190916_E(), remainingEMC / (double)itemEMC);
        long emcToStore = itemEMC * (long)numToStore;
        double amountStored = GridUtils.injectEMC(this.getProxy(), emcToStore, Actionable.SIMULATE, this.mySource);
        if (amountStored == 0.0) {
            return -1.0;
        }
        numToStore = (int)(amountStored / (double)itemEMC);
        if (usePower) {
            numToStore = Math.min(this.getMaxItemsForPower(numToStore, itemEMC), numToStore);
        }
        if (numToStore <= 0) {
            return -3.0;
        }
        emcToStore = itemEMC * (long)numToStore;
        if (usePower) {
            GridUtils.extractAEPower(this.getProxy(), (double)emcToStore * EqEConfig.emcCondenser.powerPerEMC, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        GridUtils.injectEMC(this.getProxy(), emcToStore, Actionable.MODULATE, this.mySource);
        stack.func_190918_g(numToStore);
        this.inv.setStackInSlot(slot, CommonUtils.filterForEmpty(stack));
        return remainingEMC - (double)numToStore;
    }

    protected double processStorage(int slot, double remainingEMC) {
        ItemStack stack = this.inv.getStackInSlot(slot);
        double itemEMC = ((IItemEmc)stack.func_77973_b()).getStoredEmc(stack);
        double stored = 0.0;
        if (itemEMC > 0.0) {
            double toStore = Math.min(remainingEMC, itemEMC);
            stored = GridUtils.injectEMC(this.getProxy(), toStore, Actionable.MODULATE, this.mySource);
            if (stored == 0.0) {
                return -1.0;
            }
            ((IItemEmc)stack.func_77973_b()).extractEmc(stack, stored);
            this.inv.setStackInSlot(slot, stack);
        }
        if (((IItemEmc)stack.func_77973_b()).getStoredEmc(stack) <= 0.0) {
            this.inv.setStackInSlot(slot, this.ejectItem(stack));
            if (this.inv.getStackInSlot(slot) != ItemStack.field_190927_a) {
                return -2.0;
            }
        }
        return remainingEMC - stored;
    }

    protected CondenserState processInv() {
        double remainingEMC = this.getEMCPerTick();
        for (int slot = 0; slot < 4 && remainingEMC > 0.0; ++slot) {
            ItemStack stack = this.inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IItemEmc) {
                remainingEMC = this.processStorage(slot, remainingEMC);
                continue;
            }
            if (ProjectEAPI.getEMCProxy().getValue(stack) > 0L) {
                remainingEMC = this.processItems(slot, remainingEMC, stack.func_77973_b() != ModItems.CRYSTAL);
                continue;
            }
            this.inv.setStackInSlot(slot, this.ejectItem(stack));
            if (this.inv.getStackInSlot(slot).func_190926_b()) continue;
            remainingEMC = -2.0;
        }
        switch ((int)remainingEMC) {
            case -1: {
                return CondenserState.NOEMCSTORAGE;
            }
            case -2: {
                return CondenserState.NOITEMSTORAGE;
            }
            case -3: {
                return CondenserState.NOPOWER;
            }
        }
        return CondenserState.ACTIVE;
    }

    protected boolean updateState(CondenserState newState) {
        if (!this.state.equals((Object)newState)) {
            this.state = newState;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    protected ItemStack ejectItem(ItemStack stack) {
        return GridUtils.injectItemsForPower(this.getProxy(), stack, this.mySource);
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        return (T)super.getCapability(cap, side);
    }

    protected CondenserInventoryHandler createInv() {
        return new CondenserInventoryHandler(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inv = this.createInv();
        this.inv.deserializeNBT(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_179237_a(this.inv.serializeNBT());
        return data;
    }

    protected boolean isValidItem(ItemStack stack) {
        return stack.func_77973_b() instanceof IItemEmc || ProjectEAPI.getEMCProxy().getValue(stack) > 0L && (double)ProjectEAPI.getEMCProxy().getValue(stack) <= this.getEMCPerTick();
    }

    protected static class CondenserInventoryHandler
    extends ItemStackHandler {
        private final TileEMCCondenser tile;

        public CondenserInventoryHandler(TileEMCCondenser tile) {
            super(4);
            this.tile = tile;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.tile.isValidItem(stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public void onContentsChanged(int slot) {
            this.tile.func_70296_d();
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }
    }
}

