/*
 * Decompiled with CFR 0.152.
 */
package io.github.techdweebgaming.avaritiarecipemaker.tileentities;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class VanillaRecipeMakerTileEntity
extends TileEntity {
    public static final int SIZE = 10;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            VanillaRecipeMakerTileEntity.this.func_70296_d();
        }
    };

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void outputRecipeToFile() {
        if (this.itemStackHandler.getStackInSlot(9).func_77973_b().equals(ItemStack.field_190927_a.func_77973_b()) || this.itemStackHandler.getStackInSlot(9).func_77973_b().getRegistryName().toString().equals("minecraft:air")) {
            return;
        }
        try (FileWriter fw = new FileWriter("avaritiarecipemakeroutput.txt", true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println("// " + this.itemStackHandler.getStackInSlot(9).func_82833_r());
            out.println(String.format("recipes.remove(%s);", VanillaRecipeMakerTileEntity.getRegistryName(this.itemStackHandler, 9)));
            out.println(VanillaRecipeMakerTileEntity.buildNewRecipeString(this.itemStackHandler));
            out.println("");
            out.close();
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("ERROR " + e.getLocalizedMessage());
        }
        System.out.println(VanillaRecipeMakerTileEntity.buildNewRecipeString(this.itemStackHandler));
    }

    private static String buildNewRecipeString(ItemStackHandler inventory) {
        return String.format("recipes.addShaped(%s, [[%s, %s, %s], [%s, %s, %s],[%s, %s, %s]]);", VanillaRecipeMakerTileEntity.getRegistryNameWithCount(inventory, 9), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 0), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 1), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 2), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 3), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 4), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 5), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 6), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 7), VanillaRecipeMakerTileEntity.getRegistryName(inventory, 8));
    }

    private static String getRegistryName(ItemStackHandler inventory, int slot) {
        Item item = inventory.getStackInSlot(slot).func_77973_b();
        if (item.equals(ItemStack.field_190927_a.func_77973_b()) || item.getRegistryName().toString().equals("minecraft:air")) {
            return "null";
        }
        if (item.func_77614_k()) {
            return String.format("<%s:%s>", item.getRegistryName().toString(), inventory.getStackInSlot(slot).func_77960_j());
        }
        return "<" + item.getRegistryName().toString() + ">";
    }

    private static String getRegistryNameWithCount(ItemStackHandler inventory, int slot) {
        return VanillaRecipeMakerTileEntity.getRegistryName(inventory, slot).concat(" * " + inventory.getStackInSlot(slot).func_190916_E());
    }
}

