/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.lib.Vec3D;
import net.minecraft.util.math.BlockPos;

public class ShortPos {
    private BlockPos relativeTo;

    public ShortPos(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public void setRelativeTo(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public BlockPos getRelativeTo() {
        return this.relativeTo;
    }

    public int getIntPos(BlockPos pos) {
        return ShortPos.getIntPos(pos, this.relativeTo);
    }

    public int getIntPos(Vec3D pos) {
        return ShortPos.getIntPos(pos, this.relativeTo);
    }

    public BlockPos getActualPos(int intPos) {
        return ShortPos.getBlockPos(intPos, this.relativeTo);
    }

    public static int getIntPos(BlockPos position, BlockPos relativeTo) {
        if (position.func_177956_o() > 255) {
            position = new BlockPos(position.func_177958_n(), 255, position.func_177956_o());
        } else if (position.func_177956_o() < 0) {
            position = new BlockPos(position.func_177958_n(), 0, position.func_177956_o());
        }
        int xp = position.func_177958_n() - relativeTo.func_177958_n() + 2048;
        int yp = position.func_177956_o();
        int zp = position.func_177952_p() - relativeTo.func_177952_p() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static int getIntPos(Vec3D position, BlockPos relativeTo) {
        if (position.y > 255.0) {
            position.y = 255.0;
        } else if (position.y < 0.0) {
            position.y = 0.0;
        }
        int xp = position.floorX() - relativeTo.func_177958_n() + 2048;
        int yp = position.floorY();
        int zp = position.floorZ() - relativeTo.func_177952_p() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static BlockPos getBlockPos(int intPos, BlockPos relativeTo) {
        int yp = intPos >> 24 & 0xFF;
        int xp = (intPos >> 12 & 0xFFF) - 2048;
        int zp = (intPos & 0xFFF) - 2048;
        return new BlockPos(relativeTo.func_177958_n() + xp, yp, relativeTo.func_177952_p() + zp);
    }
}

