/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.IOUtils;

public class FileHandler {
    public static File rootConfigFolder;
    public static File brandon3055Folder;
    public static File mcDirectory;
    private static final Set<Character> ILLEGAL_CHARACTERS;
    public static final Predicate<String> FILE_NAME_VALIDATOR;

    public static void init(FMLPreInitializationEvent event) {
        rootConfigFolder = event.getModConfigurationDirectory();
        brandon3055Folder = new File(rootConfigFolder, "brandon3055");
        if (!brandon3055Folder.exists() && !brandon3055Folder.mkdirs()) {
            LogHelperBC.error("Could not create config directory! Things are probably going to break!");
        }
        mcDirectory = rootConfigFolder.getParentFile();
    }

    public static void downloadFile(String sourceUrl, File output) throws IOException {
        if (!output.exists() && !output.createNewFile()) {
            throw new IOException("Could not create file, Reason unknown refresh ");
        }
        InputStream is = FileHandler.openURLStream(sourceUrl);
        FileOutputStream os = new FileOutputStream(output);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static InputStream openURLStream(URL baseUrl) throws IOException {
        return FileHandler.openURLStream(baseUrl.toString());
    }

    public static InputStream openURLStream(String url) throws IOException {
        return FileHandler.openConnection(url, null).getInputStream();
    }

    public static HttpURLConnection openConnection(String url, @Nullable Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        block3: for (int i = 0; i < 5; ++i) {
            url = url.replaceAll(" ", "%20");
            URL resourceUrl = new URL(url);
            conn = proxy != null ? (HttpURLConnection)resourceUrl.openConnection(proxy) : (HttpURLConnection)resourceUrl.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            switch (conn.getResponseCode()) {
                case 301: 
                case 302: {
                    String location = conn.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    URL base = new URL(url);
                    URL next = new URL(base, location);
                    url = next.toExternalForm();
                    continue block3;
                }
            }
        }
        return conn;
    }

    public static JsonObject readObj(File file) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
            JsonParser parser = new JsonParser();
            reader.setLenient(true);
            JsonElement element = parser.parse(reader);
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject;
        }
    }

    public static void writeJson(JsonObject obj, File file) throws IOException {
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));){
            writer.setIndent("  ");
            Streams.write((JsonElement)obj, (JsonWriter)writer);
            writer.flush();
        }
    }

    static {
        ILLEGAL_CHARACTERS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('\u0000'), Character.valueOf('\f'), Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});
        FILE_NAME_VALIDATOR = s -> {
            if (s == null || s.isEmpty()) {
                return false;
            }
            for (char c : s.toCharArray()) {
                if (!ILLEGAL_CHARACTERS.contains(Character.valueOf(c))) continue;
                return false;
            }
            return true;
        };
    }
}

