/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiPickColourDialog
extends GuiPopUpDialogBase<GuiPickColourDialog>
implements IGuiEventListener {
    public Colour colour = new ColourARGB(-1);
    public GuiButton cancelButton;
    public GuiButton selectButton;
    public GuiTextField hexField;
    public GuiSlideControl redSlider;
    public GuiSlideControl greenSlider;
    public GuiSlideControl blueSlider;
    public GuiSlideControl alphaSlider;
    public IGuiEventListener listener;
    private boolean cancelEnabled = false;
    private boolean includeAlpha = true;
    private Consumer<Colour> colourChangeListener = null;
    private Consumer<Colour> colourSelectListener = null;

    public GuiPickColourDialog(MGuiElementBase parent) {
        super(parent);
        this.setSize(80, 80);
        this.setDragBar(80);
        if (parent instanceof IGuiEventListener) {
            this.listener = (IGuiEventListener)((Object)parent);
        }
    }

    public GuiPickColourDialog(int xPos, int yPos, MGuiElementBase parent) {
        super(xPos, yPos, parent);
        this.setSize(80, 80);
        this.setDragBar(80);
        if (parent instanceof IGuiEventListener) {
            this.listener = (IGuiEventListener)((Object)parent);
        }
    }

    @Override
    public void addChildElements() {
        if (!this.includeAlpha) {
            this.colour.a = (byte)-1;
        }
        int xPos = this.xPos();
        int yPos = this.yPos();
        int xSize = this.xSize();
        int ySize = this.ySize();
        this.hexField = new GuiTextField(xPos + 4, yPos + 4, xSize - 8, 12).setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb())).setListener(this);
        this.addChild(this.hexField);
        this.hexField.setMaxStringLength(this.includeAlpha ? 8 : 6);
        this.hexField.setValidator(input -> {
            try {
                Utils.parseHex(input);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.redSlider = new GuiSlideControl(xPos + 4, this.hexField.yPos() + 14, xSize - 8, 8);
        this.addChild(this.redSlider);
        this.redSlider.setSliderElement(new GuiBorderedRect().setColours(-65536, -16777216).setBorderWidth(0.5));
        this.redSlider.updatePos((double)(this.colour.r & 0xFF) / 255.0, false);
        this.redSlider.setBarStyleBackground(-16777216).setSliderSize(3);
        this.greenSlider = new GuiSlideControl(xPos + 4, this.redSlider.yPos() + 10, xSize - 8, 8);
        this.addChild(this.greenSlider);
        this.greenSlider.setSliderElement(new GuiBorderedRect().setColours(-16711936, -16777216).setBorderWidth(0.5));
        this.greenSlider.updatePos((double)(this.colour.g & 0xFF) / 255.0, false);
        this.greenSlider.setBarStyleBackground(-16777216).setSliderSize(3);
        this.blueSlider = new GuiSlideControl(xPos + 4, this.greenSlider.yPos() + 10, xSize - 8, 8);
        this.addChild(this.blueSlider);
        this.blueSlider.setSliderElement(new GuiBorderedRect().setColours(-16776961, -16777216).setBorderWidth(0.5));
        this.blueSlider.updatePos((double)(this.colour.b & 0xFF) / 255.0, false);
        this.blueSlider.setBarStyleBackground(-16777216).setSliderSize(3);
        if (this.includeAlpha) {
            this.alphaSlider = new GuiSlideControl(xPos + 4, this.blueSlider.yPos() + 10, xSize - 8, 8);
            this.addChild(this.alphaSlider);
            this.alphaSlider.setSliderElement(new GuiBorderedRect().setColours(-1, -16777216).setBorderWidth(0.5));
            this.alphaSlider.updatePos((double)(this.colour.a & 0xFF) / 255.0, false);
            this.alphaSlider.setBarStyleBackground(-16777216).setSliderSize(3);
        }
        this.selectButton = new GuiButton(xPos + 4, yPos + ySize - 14, this.cancelEnabled ? xSize / 2 - 5 : xSize - 8, 10, I18n.func_135052_a((String)"generic.ok.txt", (Object[])new Object[0]));
        this.addChild(this.selectButton);
        this.selectButton.setListener(() -> {
            if (this.listener != null) {
                this.listener.onMGuiEvent(new GuiEvent.ColourEvent(this, this.getColourARGB(), false, false), this);
            }
            if (this.colourSelectListener != null) {
                this.colourSelectListener.accept(this.colour.copy());
            }
            this.close();
        });
        this.cancelButton = new GuiButton(this.selectButton.xPos() + this.selectButton.xSize() + 2, yPos + ySize - 14, xSize / 2 - 5, 10, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.addChild(this.cancelButton);
        this.cancelButton.setListener(() -> {
            if (this.listener != null) {
                this.listener.onMGuiEvent(new GuiEvent.ColourEvent(this, this.getColourARGB(), true, false), this);
            }
            this.close();
        });
        this.selectButton.setFillColour(-16777216).setBorderColours(-11184811, -8947849);
        this.cancelButton.setFillColour(-16777216).setBorderColours(-11184811, -8947849);
        this.cancelButton.setEnabled(this.cancelEnabled);
        super.addChildElements();
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, -1, -16777216);
        this.drawBorderedRect(this.xPos() + 4, this.yPos() + this.ySize() - 22, this.xSize() - 8, 6.0, 0.5, this.includeAlpha ? this.colour.argb() : GuiPickColourDialog.mixColours(-16777216, this.colour.argb()), -16777216);
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onMGuiEvent(GuiEvent event, MGuiElementBase eventElement) {
        boolean colourChanged = false;
        if (eventElement == this.redSlider) {
            this.colour.r = (byte)(this.redSlider.getPosition() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
            colourChanged = true;
        } else if (eventElement == this.greenSlider) {
            this.colour.g = (byte)(this.greenSlider.getPosition() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
            colourChanged = true;
        } else if (eventElement == this.blueSlider) {
            this.colour.b = (byte)(this.blueSlider.getPosition() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
            colourChanged = true;
        } else if (eventElement == this.alphaSlider) {
            this.colour.a = (byte)(this.alphaSlider.getPosition() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
            colourChanged = true;
        } else if (eventElement == this.hexField) {
            try {
                int pos = this.hexField.getCursorPosition();
                this.colour.set(Utils.parseHex(this.hexField.getText()));
                this.redSlider.updateRawPos((double)(this.colour.r & 0xFF) / 255.0);
                this.greenSlider.updateRawPos((double)(this.colour.g & 0xFF) / 255.0);
                this.blueSlider.updateRawPos((double)(this.colour.b & 0xFF) / 255.0);
                if (!this.includeAlpha) {
                    this.colour.a = (byte)-1;
                } else {
                    this.alphaSlider.updateRawPos((double)(this.colour.a & 0xFF) / 255.0);
                }
                this.hexField.setCursorPosition(pos);
                colourChanged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (colourChanged && this.colourChangeListener != null) {
            this.colourChangeListener.accept(this.colour.copy());
        }
    }

    public GuiPickColourDialog setListener(IGuiEventListener listener) {
        this.listener = listener;
        return this;
    }

    public GuiPickColourDialog setColourChangeListener(Consumer<Integer> colourChangeListener) {
        this.colourChangeListener = c -> colourChangeListener.accept(c.argb());
        this.setCancelEnabled(false);
        return this;
    }

    public GuiPickColourDialog setCCColourChangeListener(Consumer<Colour> colourChangeListener) {
        this.colourChangeListener = colourChangeListener;
        this.setCancelEnabled(false);
        return this;
    }

    public GuiPickColourDialog setColourSelectListener(Consumer<Integer> colourSelectListener) {
        this.colourSelectListener = c -> colourSelectListener.accept(c.argb());
        return this;
    }

    public GuiPickColourDialog setCCColourSelectListener(Consumer<Colour> colourSelectListener) {
        this.colourSelectListener = colourSelectListener;
        return this;
    }

    public GuiPickColourDialog setCancelEnabled(boolean cancelEnabled) {
        this.cancelEnabled = cancelEnabled;
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(cancelEnabled);
        }
        return this;
    }

    public GuiPickColourDialog setColour(int colour) {
        this.colour = new ColourARGB(colour);
        return this;
    }

    public GuiPickColourDialog setColour(Colour colour) {
        this.colour = colour;
        if (colour == null) {
            this.colour = new ColourARGB(-1);
        }
        return this;
    }

    public Colour getColour() {
        return this.colour;
    }

    public int getColourARGB() {
        return this.colour.argb();
    }

    public GuiPickColourDialog setIncludeAlpha(boolean includeAlpha) {
        this.includeAlpha = includeAlpha;
        this.setYSize(includeAlpha ? 80 : 70);
        this.setDragBar(this.ySize());
        return this;
    }
}

