/*
 * Decompiled with CFR 0.152.
 */
package org.cfpa.i18nupdatemod.installer;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.GameSettings;
import org.cfpa.i18nupdatemod.I18nUpdateMod;

public abstract class ResourcePackInstaller {
    public boolean updateResourcePack = false;

    private boolean online() {
        try {
            return InetAddress.getByName(new URL("http://downloader.meitangdehulu.com/Minecraft-Mod-Language-Modpack.zip").getHost()).isReachable(2000);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean intervalDaysCheck() {
        File f = new File(Minecraft.func_71410_x().func_110438_M().func_110612_e().toString(), "Minecraft-Mod-Language-Modpack.zip");
        try {
            return System.currentTimeMillis() - f.lastModified() > 604800000L;
        }
        catch (Throwable e) {
            I18nUpdateMod.LOGGER.error("\u68c0\u67e5\u6587\u4ef6\u65e5\u671f\u5931\u8d25", e);
            return false;
        }
    }

    void setResourcesRepository() {
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings gameSettings = mc.field_71474_y;
        if (!gameSettings.field_151453_l.contains("Minecraft-Mod-Language-Modpack.zip")) {
            mc.field_71474_y.field_151453_l.add("Minecraft-Mod-Language-Modpack.zip");
        }
        this.reloadResources();
    }

    private boolean checkLength() {
        File f = new File(Minecraft.func_71410_x().func_110438_M().func_110612_e().toString(), "Minecraft-Mod-Language-Modpack.zip");
        try {
            URL url = new URL("http://downloader.meitangdehulu.com/Minecraft-Mod-Language-Modpack.zip");
            return url.openConnection().getContentLengthLong() == f.length();
        }
        catch (Throwable e) {
            I18nUpdateMod.LOGGER.error("\u68c0\u67e5\u6587\u4ef6\u5927\u5c0f\u5931\u8d25", e);
            return false;
        }
    }

    private void reloadResources() {
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings gameSettings = mc.field_71474_y;
        ResourcePackRepository resourcePackRepository = mc.func_110438_M();
        resourcePackRepository.func_110611_a();
        List repositoryEntriesAll = resourcePackRepository.func_110609_b();
        ArrayList repositoryEntries = Lists.newArrayList();
        Iterator it = gameSettings.field_151453_l.iterator();
        block0: while (it.hasNext()) {
            String packName = (String)it.next();
            for (ResourcePackRepository.Entry entry : repositoryEntriesAll) {
                if (!entry.func_110515_d().equals(packName)) continue;
                if (entry.func_183027_f() == 3 || gameSettings.field_183018_l.contains(entry.func_110515_d())) {
                    repositoryEntries.add(entry);
                    continue block0;
                }
                it.remove();
                I18nUpdateMod.LOGGER.warn("\u79fb\u9664\u8d44\u6e90\u5305 {}\uff0c\u56e0\u4e3a\u5b83\u65e0\u6cd5\u517c\u5bb9\u5f53\u524d\u7248\u672c", (Object)entry.func_110515_d());
            }
        }
        resourcePackRepository.func_148527_a((List)repositoryEntries);
    }

    private boolean isResourcePackExist() {
        File f = new File(Minecraft.func_71410_x().func_110438_M().func_110612_e().toString(), "Minecraft-Mod-Language-Modpack.zip");
        return f.exists();
    }

    public void install() {
        if (!this.intervalDaysCheck()) {
            I18nUpdateMod.LOGGER.info("\u672a\u5230\u4e0b\u6b21\u66f4\u65b0\u65f6\u95f4\uff0c\u8df3\u8fc7\u68c0\u6d4b\u548c\u4e0b\u8f7d\u9636\u6bb5");
            this.setResourcesRepository();
        } else if (!this.online() && this.isResourcePackExist()) {
            I18nUpdateMod.LOGGER.info("\u68c0\u6d4b\u5230\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u9636\u6bb5");
            this.setResourcesRepository();
        } else if (this.checkLength()) {
            I18nUpdateMod.LOGGER.info("\u68c0\u6d4b\u5230\u8d44\u6e90\u5305\u6700\u65b0\uff0c\u8df3\u8fc7\u4e0b\u8f7d\u9636\u6bb5");
            this.setResourcesRepository();
        } else {
            this.updateResourcePack = true;
        }
    }
}

