/*
 * Decompiled with CFR 0.152.
 */
package org.cfpa.i18nupdatemod.download;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.cfpa.i18nupdatemod.download.DownloadInfoHelper;
import org.cfpa.i18nupdatemod.download.DownloadManager;
import org.cfpa.i18nupdatemod.download.DownloadStatus;

public class DownloadWindow {
    private DownloadManager manager;
    private JFrame frame;
    private JProgressBar bar;

    public DownloadWindow(DownloadManager manager) {
        this.manager = manager;
        this.init();
    }

    private void init() {
        this.frame = new JFrame();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth() >= 1920 ? (int)((double)gd.getDisplayMode().getWidth() * 0.2) : 384;
        int height = (int)((double)width * 0.3);
        this.frame.setBounds((Toolkit.getDefaultToolkit().getScreenSize().width - width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - height) / 25 * 10, width, height);
        this.frame.setTitle("\u6c49\u5316\u8d44\u6e90\u5305\u4e0b\u8f7d\u754c\u9762\uff0c\u8bf7\u7a0d\u4f5c\u7b49\u5f85");
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.frame.setContentPane(contentPane);
        contentPane.setLayout(new FlowLayout(1, 5, 5));
        this.bar = new JProgressBar();
        this.bar.setPreferredSize(new Dimension(width / 5 * 4, height / 4));
        this.bar.setStringPainted(true);
        contentPane.add(this.bar);
        this.frame.setDefaultCloseOperation(0);
        JButton btCancel = new JButton("\u53d6\u6d88\u4e0b\u8f7d"){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                super.fireActionPerformed(event);
                DownloadWindow.this.manager.cancel();
                DownloadWindow.this.frame.setVisible(false);
            }
        };
        btCancel.setLayout(new GridLayout(3, 2, 5, 5));
        btCancel.setSize(width / 5, height / 5);
        contentPane.add(btCancel);
        JButton btBackground = new JButton("\u540e\u53f0\u4e0b\u8f7d"){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                super.fireActionPerformed(event);
                DownloadWindow.this.manager.background();
                DownloadWindow.this.frame.setVisible(false);
            }
        };
        btBackground.setLayout(new GridLayout(3, 2, 5, 5));
        btBackground.setSize(width / 5, height / 5);
        contentPane.add(btBackground);
        new Thread(() -> {
            while (!this.manager.isDone()) {
                this.bar.setValue((int)(this.manager.getCompletePercentage() * 100.0f));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.onDownloadFinish();
            if (this.manager.getStatus() == DownloadStatus.FAIL) {
                this.bar.setString("\u4e0b\u8f7d\u5931\u8d25\uff01");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.frame.setVisible(false);
            } else {
                this.frame.setVisible(false);
            }
        }, "I18n-Window-Thread").start();
        new Thread(() -> {
            try {
                while (this.manager.getStatus() == DownloadStatus.IDLE) {
                    Thread.sleep(50L);
                }
                for (int i = 30; !this.manager.isDone() && i >= 0; --i) {
                    btBackground.setText("\u540e\u53f0\u4e0b\u8f7d(" + i + ')');
                    Thread.sleep(1000L);
                    if (i != 0) continue;
                    this.background();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).start();
    }

    public void showWindow() {
        this.frame.setVisible(true);
    }

    public void background() {
        this.frame.setVisible(false);
        this.manager.background();
    }

    private void onDownloadFinish() {
        if (!this.frame.isVisible()) {
            if (this.manager.getStatus() == DownloadStatus.SUCCESS) {
                DownloadInfoHelper.info.add("\u8d44\u6e90\u5305\u540e\u53f0\u4e0b\u8f7d\u5b8c\u6210\uff0c\u4e0b\u6b21\u91cd\u542f\u6e38\u620f\u5c06\u52a0\u8f7d\u8d44\u6e90\u5305");
            } else {
                DownloadInfoHelper.info.add("\u8d44\u6e90\u5305\u540e\u53f0\u4e0b\u8f7d\u5931\u8d25");
            }
        }
    }
}

