/*
 * Decompiled with CFR 0.152.
 */
package org.cfpa.i18nupdatemod.download;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.cfpa.i18nupdatemod.I18nUpdateMod;
import org.cfpa.i18nupdatemod.download.DownloadInfoHelper;
import org.cfpa.i18nupdatemod.download.DownloadStatus;

public class DownloadManager {
    private Thread downloadThread;
    private MainDownloader downloader;
    private DownloadStatus status = DownloadStatus.IDLE;

    public DownloadManager(String urlIn, String fileNameIn, String dirIn) {
        try {
            this.downloader = new MainDownloader(urlIn, fileNameIn, dirIn);
        }
        catch (IOException e) {
            this.catching(e);
        }
    }

    public void setSuccessTask(Runnable successTask) {
        this.downloader.successTask = successTask;
    }

    public void start(String threadName) {
        this.status = DownloadStatus.DOWNLOADING;
        this.downloadThread = new Thread(() -> {
            try {
                this.downloader.downloadResource();
            }
            catch (Throwable e) {
                this.catching(e);
            }
        }, threadName);
        this.downloadThread.start();
    }

    public void cancel() {
        this.downloader.done = true;
        this.status = DownloadStatus.CANCELED;
        this.downloader.alive = false;
    }

    public void background() {
        this.status = DownloadStatus.BACKGROUND;
    }

    private void catching(Throwable e) {
        I18nUpdateMod.LOGGER.error("\u4e0b\u8f7d\u5931\u8d25", e);
        DownloadInfoHelper.info.add("\u8d44\u6e90\u5305\u66f4\u65b0\u5931\u8d25\u3002");
        this.status = DownloadStatus.FAIL;
        this.downloader.done = true;
    }

    public DownloadStatus getStatus() {
        if ((this.status == DownloadStatus.DOWNLOADING || this.status == DownloadStatus.BACKGROUND) && this.downloader.done) {
            this.status = DownloadStatus.SUCCESS;
        }
        return this.status;
    }

    public boolean isDone() {
        return this.downloader.done;
    }

    public float getCompletePercentage() {
        return this.downloader.completePercentage;
    }

    private static class MainDownloader {
        private URL url;
        private String fileName;
        private String dirPlace;
        private int size = 0;
        private int downloadedSize = 0;
        private boolean done = false;
        Runnable successTask;
        public float completePercentage = 0.0f;
        public boolean alive = true;

        MainDownloader(String urlIn, String fileName, String dirPlace) throws IOException {
            this.url = new URL(urlIn);
            this.fileName = fileName;
            this.dirPlace = dirPlace;
        }

        void downloadResource() throws Throwable {
            URLConnection connection = this.url.openConnection();
            connection.setConnectTimeout(10000);
            this.size = connection.getContentLength();
            InputStream inputStream = connection.getInputStream();
            byte[] getData = this.readInputStream(inputStream);
            if (getData != null) {
                File saveDir = new File(this.dirPlace);
                if (!saveDir.exists()) {
                    saveDir.mkdir();
                }
                File file = new File(saveDir + File.separator + this.fileName);
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(getData);
                fos.close();
                inputStream.close();
            }
            this.done = true;
            if (this.successTask != null) {
                this.successTask.run();
            }
        }

        private byte[] readInputStream(InputStream inputStream) throws IOException {
            int len;
            byte[] buffer = new byte[64];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
                this.downloadedSize += len;
                this.completePercentage = (float)this.downloadedSize / (float)this.size;
                if (this.alive) continue;
                return null;
            }
            bos.close();
            return bos.toByteArray();
        }
    }
}

