/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.immersivepetroleum;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.recipe.Fuels;
import techreborn.api.recipe.Recipes;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemDynamicCell;

@RebornRegistry(modOnly="immersivepetroleum", modID="techreborn")
public class ImmersivePetroleumCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="immersive_petroleum", key="EnableDistillationTowerImmersivePetroleumRecipes", comment="Enable distillation tower recipes related to Immersive Petroleum content")
    public static boolean enableDistillationTowerImmersivePetroleumRecipes = true;
    @ConfigRegistry(config="compat", category="immersive_petroleum", key="EnableChemicalReactorImmersivePetroleumRecipes", comment="Enable chemical reactor recipes related to Immersive Petroleum content")
    public static boolean enableChemicalReactorImmersivePetroleumRecipes = true;
    @ConfigRegistry(config="compat", category="immersive_petroleum", key="EnableImmersivePetroleumFuels", comment="Allow Immersive Petroleum fuels to be used in the fuel generators")
    public static boolean enableImmersivePetroleumFuels = true;

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void init(FMLInitializationEvent event) {
        Fluid crudeOil;
        if (enableDistillationTowerImmersivePetroleumRecipes && (crudeOil = FluidRegistry.getFluid((String)"oil")) != null) {
            RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemDynamicCell.getCellWithFluid((Fluid)crudeOil, (int)16), (Object)ItemDynamicCell.getEmptyCell((int)33), RecipeMethods.getMaterial((String)"diesel", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"sulfuricAcid", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"glyceryl", (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"methane", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), 16000, 16));
        }
        if (enableChemicalReactorImmersivePetroleumRecipes) {
            crudeOil = FluidRegistry.getFluid((String)"oil");
            Fluid napalm = FluidRegistry.getFluid((String)"napalm");
            if (crudeOil != null && napalm != null) {
                Recipes.chemicalReactor.createRecipe().withInput("dustAluminum", 6).withInput(ItemDynamicCell.getCellWithFluid((Fluid)crudeOil, (int)1)).withOutput(ItemDynamicCell.getCellWithFluid((Fluid)napalm, (int)1)).withEnergyCostPerTick(30).withOperationDuration(1000).register();
                Recipes.chemicalReactor.createRecipe().withInput("dustAluminium", 6).withInput(ItemDynamicCell.getCellWithFluid((Fluid)crudeOil, (int)1)).withOutput(ItemDynamicCell.getCellWithFluid((Fluid)napalm, (int)1)).withEnergyCostPerTick(30).withOperationDuration(1000).register();
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (enableImmersivePetroleumFuels) {
            Fluid napalm;
            Fluid gasoline;
            Fluid diesel;
            Fluid crudeOil = FluidRegistry.getFluid((String)"oil");
            if (crudeOil != null) {
                Fuels.semiFluidGenerator.addFuel().addFluidSource(crudeOil).withEnergyOutput(16.0).withEnergyPerTick(8.0).register();
            }
            if ((diesel = FluidRegistry.getFluid((String)"diesel")) != null) {
                Fuels.dieselGenerator.addFuel().addFluidSource(diesel).withEnergyOutput(384.0).withEnergyPerTick(20.0).register();
            }
            if ((gasoline = FluidRegistry.getFluid((String)"gasoline")) != null) {
                Fuels.dieselGenerator.addFuel().addFluidSource(gasoline).withEnergyOutput(384.0).withEnergyPerTick(20.0).register();
            }
            if ((napalm = FluidRegistry.getFluid((String)"napalm")) != null) {
                Fuels.dieselGenerator.addFuel().addFluidSource(napalm).withEnergyOutput(400.0).withEnergyPerTick(20.0).register();
            }
        }
    }
}

