/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import gnu.trove.set.hash.TCharHashSet;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.RollingMachineRecipe;
import techreborn.api.TechRebornAPI;
import techreborn.compatmod.crafttweaker.CraftTweakerCompat;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.rollingMachine")
public class CTRollingMachine {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient[][] ingredients")
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        TechRebornAPI.addRollingOreMachinceRecipe((ResourceLocation)RollingMachineRecipe.getNameForRecipe((ItemStack)CraftTweakerCompat.toStack(output)), (ItemStack)CraftTweakerCompat.toStack(output), (Object[])CTRollingMachine.toShapedObjects(ingredients));
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient[] ingredients")
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        TechRebornAPI.addShapelessOreRollingMachinceRecipe((ResourceLocation)RollingMachineRecipe.getNameForRecipe((ItemStack)CraftTweakerCompat.toStack(output)), (ItemStack)CraftTweakerCompat.toStack(output), (Object[])CTRollingMachine.toObjects(ingredients));
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        ArrayList toRemove = new ArrayList();
        for (Map.Entry recipe : RollingMachineRecipe.instance.getRecipeList().entrySet()) {
            if (!ItemUtils.isItemEqual((ItemStack)((IRecipe)recipe.getValue()).func_77571_b(), (ItemStack)CraftTweakerCompat.toStack(output), (boolean)true, (boolean)false)) continue;
            toRemove.add(recipe.getKey());
        }
        for (ResourceLocation resourceLocation : toRemove) {
            RollingMachineRecipe.instance.getRecipeList().remove(resourceLocation);
        }
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        TCharHashSet usedCharSet = new TCharHashSet();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                usedCharSet.add(map[x][y]);
                prep.add(CraftTweakerCompat.toObject(ingredients[x][y]));
            }
        }
        for (int i = 0; i < 3; ++i) {
            StringBuilder sb = new StringBuilder();
            if (!(prep.get(i) instanceof String)) continue;
            String s = (String)prep.get(i);
            for (int j = 0; j < 3; ++j) {
                char c = s.charAt(j);
                if (usedCharSet.contains(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append(" ");
            }
            prep.set(i, sb.toString());
        }
        return prep.toArray();
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? CraftTweakerCompat.toObject(ingredient[i]) : "";
        }
        return output;
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            RollingMachineRecipe.instance.getRecipeList().clear();
        }

        public String describe() {
            return "Removing all Rolling Machine recipes";
        }
    }
}

