/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.tileentities;

import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.IBlockOverlayText;
import com.teamacronymcoders.base.tileentities.TileEntityBase;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntitySidedBase<CAP>
extends TileEntityBase
implements IBlockOverlayText {
    private SideType[] sideTypes = new SideType[6];
    private boolean isColorBlindActive;

    public TileEntitySidedBase() {
        Arrays.fill((Object[])this.sideTypes, (Object)SideType.NONE);
        this.isColorBlindActive = false;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void toggleSide(int side) {
        this.setSideType(side, this.getSideValue(side).next());
        this.updateBlock();
    }

    public void updateBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), true);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
        }
    }

    public void setSideType(int side, SideType sideType) {
        this.sideTypes[side] = sideType;
    }

    public SideType getSideValue(int side) {
        return this.sideTypes[side];
    }

    public SideType getSideValue(EnumFacing facing) {
        return this.getSideValue(facing.ordinal());
    }

    @Override
    protected void readFromDisk(NBTTagCompound data) {
        this.setSideTypesFromNBT(data);
        this.readCapability(data);
    }

    protected abstract void readCapability(NBTTagCompound var1);

    @Override
    protected NBTTagCompound writeToDisk(NBTTagCompound data) {
        this.setSideTypesToNBT(data);
        this.writeCapability(data);
        return data;
    }

    protected abstract void writeCapability(NBTTagCompound var1);

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), true);
            return true;
        }
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == this.getCapabilityType()) {
            return facing == null || this.getSideValue(facing) != SideType.NONE;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == this.getCapabilityType()) {
            if (facing != null) {
                SideType sideType = this.getSideValue(facing.func_176745_a());
                if (sideType == SideType.INPUT) {
                    return this.castCapability(this.getInputCapability());
                }
                if (sideType == SideType.OUTPUT) {
                    return this.castCapability(this.getOutputCapability());
                }
            } else {
                return this.castCapability(this.getInternalCapability());
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    protected abstract Capability<CAP> getCapabilityType();

    protected <T> T castCapability(CAP cap) {
        return (T)this.getCapabilityType().cast(cap);
    }

    protected abstract CAP getInternalCapability();

    protected abstract CAP getOutputCapability();

    protected abstract CAP getInputCapability();

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getOverlayText(EntityPlayer player, RayTraceResult rayTrace, boolean tool) {
        if (tool && this.isColorBlindActive) {
            SideType facing = this.sideTypes[rayTrace.field_178784_b.ordinal()];
            SideType opposite = this.sideTypes[rayTrace.field_178784_b.func_176734_d().ordinal()];
            return new String[]{I18n.func_135052_a((String)"base.block_side.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("base.sidetype." + facing.name().toLowerCase()), (Object[])new Object[0]), I18n.func_135052_a((String)"base.block_side.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("base.sidetype." + opposite.name().toLowerCase()), (Object[])new Object[0])};
        }
        return null;
    }

    protected void setSideTypesToNBT(NBTTagCompound nbt) {
        int[] array = new int[6];
        for (int i = 0; i < this.sideTypes.length; ++i) {
            array[i] = this.sideTypes[i].ordinal();
        }
        nbt.func_74783_a("sideTypes", array);
    }

    protected void setSideTypesFromNBT(NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k("sideTypes");
        if (this.sideTypes == null) {
            this.sideTypes = new SideType[6];
        }
        for (int i = 0; i < array.length; ++i) {
            this.sideTypes[i] = SideType.values()[array[i]];
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.setSideTypesToNBT(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
        this.setSideTypesToNBT(nbt);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.setSideTypesFromNBT(pkt.func_148857_g());
    }
}

