/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class NoClassloadClassWriter
extends ClassWriter {
    private static final Logger logger = LogManager.getLogger();
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false"));
    private static final String OBJECT = "java/lang/Object";
    private static final Map<String, ClassInfo> nodeCache = new HashMap<String, ClassInfo>();
    private static final DeobfuscationTransformer deobf = new DeobfuscationTransformer();

    public NoClassloadClassWriter(int flags) {
        super(flags);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(OBJECT) || type2.equals(OBJECT)) {
            return OBJECT;
        }
        ClassInfo class1 = this.getClassInfo(type1);
        ClassInfo class2 = this.getClassInfo(type2);
        if (class1 == null || class2 == null) {
            if (DEBUG) {
                logger.info("Class info was null");
            }
            return OBJECT;
        }
        String res = this.getCommonSuperClass(class1, class2);
        if (DEBUG) {
            logger.info("Common supertype of {} and {}: {}", (Object)type1, (Object)type2, (Object)res);
        }
        return res;
    }

    private String getCommonSuperClass(ClassInfo class1, ClassInfo class2) {
        if (class1 == null || class1.superName == null || class2 == null || class2.superName == null) {
            if (DEBUG) {
                logger.info("Input was Object or null");
            }
            return OBJECT;
        }
        if (class1.isSuper(class2)) {
            if (DEBUG) {
                logger.info("type1 super == type2");
            }
            return class2.name;
        }
        if (class2.isSuper(class1)) {
            if (DEBUG) {
                logger.info("type2 super == type1");
            }
            return class1.name;
        }
        if (class1.isInterface() || class2.isInterface()) {
            if (DEBUG) {
                logger.info("Input was interface");
            }
            return OBJECT;
        }
        if (DEBUG) {
            logger.info("Walking hierarchy");
        }
        ClassInfo parent = class1;
        do {
            if ((class1 = this.getClassInfo(class1.superName)) == null || class1.superName == null) {
                if (DEBUG) {
                    logger.info("Reached object or null, recursing with {} and {}", (Object)parent.name, (Object)class2.superName);
                }
                if ((class2 = this.getClassInfo(class2.superName)) == null || !class2.isValid()) {
                    logger.info("Class 2 super was object or null");
                    return OBJECT;
                }
                return this.getCommonSuperClass(parent, class2);
            }
            if (!DEBUG) continue;
            logger.info("Comparing {} to {}", (Object)class2.superName, (Object)class1.name);
        } while (!class2.isSuper(class1));
        return class1.name;
    }

    private ClassInfo getClassInfo(String name) {
        ClassReader cr;
        ClassInfo cn = nodeCache.get(name);
        if (cn != null) {
            return cn;
        }
        cn = new ClassInfo();
        try {
            cr = new ClassReader(this.getClassBytes(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        cr.accept((ClassVisitor)cn, 7);
        nodeCache.put(name, cn);
        return cn;
    }

    public byte[] getClassBytes(String className) throws ClassNotFoundException, IOException {
        String name = FMLDeobfuscatingRemapper.INSTANCE.unmap(className);
        String transformedName = className.replace('/', '.');
        byte[] classBytes = this.getClassBytes(name, transformedName);
        if ((classBytes = deobf.transform(className, name, classBytes)) == null) {
            throw new ClassNotFoundException(String.format("The specified class '%s' was not found", transformedName));
        }
        return classBytes;
    }

    private byte[] getClassBytes(String name, String transformedName) throws IOException {
        byte[] classBytes = this.getClassBytes(name, transformedName, (URLClassLoader)Launch.classLoader);
        if (classBytes == null) {
            classBytes = this.getClassBytes(name, transformedName, (URLClassLoader)Launch.class.getClassLoader());
        }
        return classBytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getClassBytes(String name, String transformedName, URLClassLoader classLoader) throws IOException {
        URL resource;
        String resourcePath = name.replace('.', '/').concat(".class");
        String deobfResourcePath = transformedName.replace('.', '/').concat(".class");
        if (DEBUG) {
            logger.info("Attempting to load class {} with classloader {}", (Object)deobfResourcePath, (Object)classLoader);
        }
        if ((resource = classLoader.getResource(resourcePath)) == null && !resourcePath.equals(deobfResourcePath)) {
            resource = classLoader.getResource(deobfResourcePath);
        }
        if (resource == null) {
            if (!DEBUG) return null;
            logger.info("No resource found");
            return null;
        }
        try (InputStream classStream = resource.openStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)classStream);
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static class ClassInfo
    extends ClassVisitor {
        public int access;
        public String name;
        public String superName;

        public ClassInfo() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.access = access;
            this.name = name;
            this.superName = superName;
        }

        boolean isValid() {
            return this.name != null && this.superName != null;
        }

        boolean isSuper(ClassInfo other) {
            return this.superName.equals(other.name);
        }

        boolean isInterface() {
            return (this.access & 0x200) != 0;
        }
    }
}

