/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.transform.SimpleMixin;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFF)
public class EnderCorePlugin
implements IFMLLoadingPlugin {
    static final Logger mainLogger = LogManager.getLogger((String)"EnderCore ASM");
    static final Logger mixinLogger = LogManager.getLogger((String)"EnderCore Mixins");
    public static boolean runtimeDeobfEnabled = false;
    private static EnderCorePlugin instance;
    Set<MixinData> mixins = new LinkedHashSet<MixinData>();

    public EnderCorePlugin() {
        if (instance != null) {
            throw new IllegalStateException("EnderCorePlugin was instantiated twice?");
        }
        instance = this;
    }

    @Nonnull
    public static EnderCorePlugin instance() {
        EnderCorePlugin inst = instance;
        if (inst == null) {
            throw new IllegalStateException("EnderCorePlugin accessed too early!");
        }
        return inst;
    }

    public void loadMixinSources(Object mod) {
        this.loadMixinSources(mod.getClass().getPackage());
    }

    public void loadMixinSources(Package filter) {
        this.loadMixinSources(filter.getName());
    }

    public void loadMixinSources(String packageFilter) {
        List<MixinData> fromAnnotations = this.findAnnotationMixins(packageFilter);
        fromAnnotations.forEach(this.mixins::add);
        fromAnnotations.forEach(m -> m.initialize(m.source));
        fromAnnotations.forEach(m -> m.initialize(m.target));
    }

    private List<MixinData> findAnnotationMixins(String packageFilter) {
        ArrayList<MixinData> ret = new ArrayList<MixinData>();
        try {
            Field fDiscoverer = Loader.class.getDeclaredField("discoverer");
            fDiscoverer.setAccessible(true);
            ModDiscoverer discoverer = (ModDiscoverer)fDiscoverer.get(Loader.instance());
            ASMDataTable asmData = discoverer.getASMTable();
            HashSet data = new HashSet();
            data.addAll(asmData.getAll(com.enderio.core.common.mixin.SimpleMixin.class.getName()));
            data.addAll(asmData.getAll(SimpleMixin.class.getName()));
            for (ASMDataTable.ASMData d : data) {
                if (!d.getClassName().startsWith(packageFilter)) continue;
                mixinLogger.info("Found annotation mixin: {}", (Object)d.getClassName());
                List dependencies = (List)MoreObjects.firstNonNull((Object)((List)d.getAnnotationInfo().get("dependencies")), Collections.emptyList());
                List missingDependencies = dependencies.stream().filter(m -> !Loader.isModLoaded((String)m) && !ModAPIManager.INSTANCE.hasAPI(m)).collect(Collectors.toList());
                if (missingDependencies.size() == 0) {
                    ret.add(new MixinData(d.getClassName(), ((Type)d.getAnnotationInfo().get("value")).getClassName()));
                    mixinLogger.info("Registered mixin.");
                    continue;
                }
                mixinLogger.info("Skipping mixin due to missing dependencies: {}", missingDependencies);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"com.enderio.core.common.transform.EnderCoreTransformer", "com.enderio.core.common.transform.SimpleMixinPatcher"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        runtimeDeobfEnabled = (Boolean)data.get("runtimeDeobfuscationEnabled");
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static class MixinData {
        public final String source;
        public final String target;

        MixinData(String source, String target) {
            this.source = source;
            this.target = target;
        }

        void initialize(String clazz) {
            try {
                Class<?> cls = Class.forName(clazz);
                cls.getName();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MixinData other = (MixinData)obj;
            return this.source.equals(other.source) && this.target.equals(other.target);
        }
    }
}

