/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.tile;

import com.latmod.mods.projectex.ProjectEXConfig;
import com.latmod.mods.projectex.ProjectEXUtils;
import com.latmod.mods.projectex.integration.PersonalEMC;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.event.PlayerAttemptCondenserSetEvent;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileLink
extends TileEntity
implements IItemHandlerModifiable,
ITickable,
IEmcAcceptor {
    public UUID owner = new UUID(0L, 0L);
    public String name = "";
    private boolean isDirty = false;
    public final ItemStack[] inputSlots;
    public final ItemStack[] outputSlots;
    public long storedEMC = 0L;

    public TileLink(int in, int out) {
        this.inputSlots = new ItemStack[in];
        this.outputSlots = new ItemStack[out];
        Arrays.fill(this.inputSlots, ItemStack.field_190927_a);
        Arrays.fill(this.outputSlots, ItemStack.field_190927_a);
    }

    public boolean learnItems() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.owner = nbt.func_186857_a("owner");
        this.name = nbt.func_74779_i("name");
        double storedEMC1 = nbt.func_74769_h("emc");
        this.storedEMC = storedEMC1 > 9.223372036854776E18 ? Long.MAX_VALUE : (long)storedEMC1;
        Arrays.fill(this.inputSlots, ItemStack.field_190927_a);
        Arrays.fill(this.outputSlots, ItemStack.field_190927_a);
        NBTTagList inputList = nbt.func_150295_c("input", 10);
        for (int i = 0; i < inputList.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = inputList.func_150305_b(i);
            this.inputSlots[nbt1.func_74771_c((String)"Slot")] = new ItemStack(nbt1);
        }
        NBTTagList outputList = nbt.func_150295_c("output", 10);
        if (outputList.func_82582_d()) {
            this.outputSlots[0] = ProjectEXUtils.fixOutput(new ItemStack(nbt.func_74775_l("output")));
        } else {
            for (int i = 0; i < outputList.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = outputList.func_150305_b(i);
                this.outputSlots[nbt1.func_74771_c((String)"Slot")] = ProjectEXUtils.fixOutput(new ItemStack(nbt1));
            }
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_186854_a("owner", this.owner);
        nbt.func_74778_a("name", this.name);
        if ((double)this.storedEMC > 0.0) {
            nbt.func_74780_a("emc", (double)this.storedEMC);
        }
        NBTTagList outputList = new NBTTagList();
        for (int i = 0; i < this.outputSlots.length; ++i) {
            this.outputSlots[i].func_190920_e(1);
            if (this.outputSlots[i].func_190926_b()) continue;
            NBTTagCompound nbt1 = this.outputSlots[i].serializeNBT();
            nbt1.func_74774_a("Slot", (byte)i);
            outputList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("output", (NBTBase)outputList);
        NBTTagList inputList = new NBTTagList();
        for (int i = 0; i < this.inputSlots.length; ++i) {
            if (this.inputSlots[i].func_190926_b()) continue;
            NBTTagCompound nbt1 = this.inputSlots[i].serializeNBT();
            nbt1.func_74774_a("Slot", (byte)i);
            inputList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("input", (NBTBase)inputList);
        return super.func_189515_b(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, side));
    }

    public int getSlots() {
        return this.inputSlots.length + this.outputSlots.length;
    }

    public boolean hasOwner() {
        return this.owner.getLeastSignificantBits() != 0L || this.owner.getMostSignificantBits() != 0L;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < this.inputSlots.length) {
            return this.inputSlots[slot];
        }
        if (ProjectEXConfig.general.emc_link_max_out <= 0) {
            return ItemStack.field_190927_a;
        }
        int index = slot - this.inputSlots.length;
        if (this.field_145850_b.field_72995_K || !this.hasOwner()) {
            return ItemStack.field_190927_a;
        }
        this.outputSlots[index].func_190920_e(1);
        if (this.outputSlots[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        long value = ProjectEAPI.getEMCProxy().getValue(this.outputSlots[index]);
        if (value > 0L) {
            int c = this.getCount(PersonalEMC.get(this.field_145850_b, this.owner), value, ProjectEXConfig.general.emc_link_max_out);
            if (c <= 0) {
                return ItemStack.field_190927_a;
            }
            this.outputSlots[index].func_190920_e(c);
            return this.outputSlots[index];
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < this.inputSlots.length) {
            this.inputSlots[slot] = stack;
            this.func_70296_d();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot >= this.inputSlots.length || !ProjectEAPI.getEMCProxy().hasValue(stack)) {
            return stack;
        }
        int limit = stack.func_77976_d();
        if (!this.inputSlots[slot].func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.inputSlots[slot])) {
                return stack;
            }
            limit -= this.inputSlots[slot].func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (this.inputSlots[slot].func_190926_b()) {
                this.inputSlots[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
            } else {
                this.inputSlots[slot].func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot < this.inputSlots.length && ProjectEAPI.getEMCProxy().hasValue(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.inputSlots.length || amount <= 0 || this.field_145850_b.field_72995_K || !this.hasOwner()) {
            return ItemStack.field_190927_a;
        }
        int index = slot - this.inputSlots.length;
        this.outputSlots[index].func_190920_e(1);
        if (this.outputSlots[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        long value = ProjectEAPI.getEMCProxy().getValue(this.outputSlots[index]);
        if (value <= 0L) {
            return ItemStack.field_190927_a;
        }
        IKnowledgeProvider knowledgeProvider = null;
        if (this.storedEMC < value && ((knowledgeProvider = PersonalEMC.get(this.field_145850_b, this.owner)) == null || knowledgeProvider.getEmc() < value)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.outputSlots[index].func_77946_l();
        stack.func_190920_e(this.getCount(knowledgeProvider, value, Math.min(amount, this.outputSlots[index].func_77976_d())));
        if (stack.func_190916_E() >= 1) {
            if (!simulate) {
                long v = value * (long)stack.func_190916_E();
                if (this.storedEMC >= v) {
                    this.storedEMC -= v;
                    this.func_70296_d();
                } else if (knowledgeProvider != null) {
                    PersonalEMC.remove(knowledgeProvider, v);
                }
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return slot < this.inputSlots.length ? 64 : ProjectEXConfig.general.emc_link_max_out;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove((Object)this);
        }
        this.func_145829_t();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.hasOwner()) {
            IKnowledgeProvider knowledgeProvider = PersonalEMC.get(this.field_145850_b, this.owner);
            boolean syncKnowledge = false;
            for (int i = 0; i < this.inputSlots.length; ++i) {
                double value;
                if (this.inputSlots[i].func_190926_b() || !((value = (double)ProjectEAPI.getEMCProxy().getValue(this.inputSlots[i])) > 0.0)) continue;
                if (knowledgeProvider != null && this.learnItems()) {
                    syncKnowledge = knowledgeProvider.addKnowledge(ProjectEXUtils.fixOutput(this.inputSlots[i]));
                }
                this.storedEMC = (long)((double)this.storedEMC + (double)this.inputSlots[i].func_190916_E() * value * ProjectEConfig.difficulty.covalenceLoss);
                this.inputSlots[i] = ItemStack.field_190927_a;
                this.func_70296_d();
            }
            if (knowledgeProvider != null) {
                EntityPlayerMP player;
                if ((double)this.storedEMC > 0.0) {
                    PersonalEMC.add(knowledgeProvider, this.storedEMC);
                    this.storedEMC = 0L;
                    this.func_70296_d();
                }
                if (syncKnowledge && (player = this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner)) != null) {
                    knowledgeProvider.sync(player);
                }
            }
        }
        if (this.isDirty) {
            this.isDirty = false;
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public int getCount(@Nullable IKnowledgeProvider knowledgeProvider, long value, int limit) {
        long emc;
        long l = emc = knowledgeProvider == null ? this.storedEMC : knowledgeProvider.getEmc();
        if (emc < value) {
            return 0;
        }
        return (int)Math.min((long)limit, emc / value);
    }

    public long acceptEMC(EnumFacing facing, long v) {
        if (!this.field_145850_b.field_72995_K) {
            this.storedEMC += v;
            this.func_70296_d();
        }
        return v;
    }

    public long getStoredEmc() {
        return this.storedEMC;
    }

    public long getMaximumEmc() {
        return Long.MAX_VALUE;
    }

    public boolean setOutputStack(EntityPlayer player, int slot, ItemStack stack, boolean addKnowledge) {
        stack = ProjectEXUtils.fixOutput(stack);
        IKnowledgeProvider knowledgeProvider = PersonalEMC.get(player);
        if (addKnowledge) {
            ProjectEXUtils.addKnowledge(player, knowledgeProvider, stack);
        }
        if (ProjectEAPI.getEMCProxy().hasValue(stack) && (addKnowledge || knowledgeProvider.hasKnowledge(stack))) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptCondenserSetEvent(player, stack))) {
                this.outputSlots[slot] = stack;
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }
}

