/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.tile;

import com.latmod.mods.projectex.ProjectEXUtils;
import com.latmod.mods.projectex.tile.AlchemyTableRecipe;
import com.latmod.mods.projectex.tile.AlchemyTableRecipes;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.ItemStackHandler;

public class TileAlchemyTable
extends TileEntity
implements ITickable,
IEmcAcceptor {
    public long storedEMC = 0L;
    public int progress = 0;
    public long totalCost = 0L;
    public int totalProgress = 0;
    public final ItemStackHandler items = new ItemStackHandler(2){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 1 || !AlchemyTableRecipes.INSTANCE.hasOutput(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && AlchemyTableRecipes.INSTANCE.hasOutput(stack);
        }
    };

    public void func_145839_a(NBTTagCompound nbt) {
        this.storedEMC = nbt.func_74763_f("emc");
        this.progress = nbt.func_74762_e("progress");
        NBTTagCompound itemsTag = new NBTTagCompound();
        itemsTag.func_74782_a("Items", (NBTBase)nbt.func_150295_c("items", 10));
        this.items.deserializeNBT(itemsTag);
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.storedEMC > 0L) {
            nbt.func_74772_a("emc", this.storedEMC);
        }
        if (this.progress > 0) {
            nbt.func_74768_a("progress", this.progress);
        }
        nbt.func_74782_a("items", this.items.serializeNBT().func_74781_a("Items"));
        return super.func_189515_b(nbt);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove((Object)this);
        }
        this.func_145829_t();
    }

    public void func_73660_a() {
        boolean hasOutput;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.totalCost = 0L;
        this.totalProgress = 0;
        ItemStack output = this.items.getStackInSlot(1);
        boolean bl = hasOutput = !output.func_190926_b();
        if (hasOutput && output.func_190916_E() >= output.func_77976_d()) {
            return;
        }
        ItemStack input = this.items.getStackInSlot(0);
        AlchemyTableRecipe recipe = AlchemyTableRecipes.INSTANCE.getOutput(input);
        if (recipe == null) {
            return;
        }
        if (hasOutput && (recipe.output.func_190926_b() || recipe.output.func_77973_b() != output.func_77973_b() || recipe.output.func_77960_j() != output.func_77960_j())) {
            return;
        }
        this.totalCost = recipe.getTotalCost();
        this.totalProgress = recipe.getTotalProgress();
        if (this.storedEMC < this.totalCost) {
            return;
        }
        ++this.progress;
        if (this.progress >= this.totalProgress) {
            this.storedEMC -= this.totalCost;
            this.progress = 0;
            input.func_190918_g(1);
            this.items.setStackInSlot(0, input);
            if (hasOutput) {
                output.func_190917_f(1);
                this.items.setStackInSlot(1, output);
            } else {
                this.items.setStackInSlot(1, ProjectEXUtils.fixOutput(recipe.output));
            }
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public long acceptEMC(EnumFacing facing, long v) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.totalCost <= 0L) {
                return 0L;
            }
            long d = Math.min(v, this.getMaximumEmc() - this.storedEMC);
            this.storedEMC += d;
            this.func_70296_d();
            return d;
        }
        return 0L;
    }

    public long getStoredEmc() {
        return this.storedEMC;
    }

    public long getMaximumEmc() {
        return this.totalCost * 8L;
    }
}

