/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.Level;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedtunnels.core.part.PartStateRoundRobin;

public interface IChanneledTarget<N extends IPositionedAddonsNetwork> {
    public INetwork getNetwork();

    public N getChanneledNetwork();

    public boolean hasValidTarget();

    public PartStateRoundRobin<?> getPartState();

    public int getChannel();

    public boolean isRoundRobin();

    public boolean isCraftIfFailed();

    public void preTransfer();

    public void postTransfer();

    public static INetwork getNetworkChecked(PartPos pos) throws PartStateException {
        INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getPos().getWorld(), (BlockPos)pos.getPos().getBlockPos(), (EnumFacing)pos.getSide());
        if (network == null) {
            IntegratedDynamics.clog((Level)Level.ERROR, (String)"Could not get the network for transfer as no network was found.");
            throw new PartStateException(pos.getPos(), pos.getSide());
        }
        return network;
    }

    @Nullable
    public static PartStateRoundRobin<?> getPartState(PartPos center) {
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)center);
        if (partStateHolder == null) {
            return null;
        }
        return (PartStateRoundRobin)partStateHolder.getState();
    }
}

