/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceFluid
extends PartTypeInterfacePositionedAddon<IFluidNetwork, IFluidHandler, PartTypeInterfaceFluid, State> {
    public PartTypeInterfaceFluid(String name) {
        super(name);
    }

    @Override
    protected Capability<IFluidNetwork> getNetworkCapability() {
        return FluidNetworkConfig.CAPABILITY;
    }

    @Override
    protected Capability<IFluidHandler> getTargetCapability() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceFluidBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<PartTypeInterfaceFluid, IFluidNetwork, IFluidHandler>
    implements IFluidHandler {
        @Override
        protected Capability<IFluidHandler> getTargetCapability() {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }

        protected IFluidHandler getFluidHandler() {
            return (IFluidHandler)((IFluidNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getChannel());
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!this.isNetworkAndPositionValid()) {
                return new IFluidTankProperties[0];
            }
            this.disablePosition();
            IFluidTankProperties[] ret = this.getFluidHandler().getTankProperties();
            this.enablePosition();
            return ret;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getFluidHandler().fill(resource, doFill);
            this.enablePosition();
            return ret;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!this.isNetworkAndPositionValid()) {
                return null;
            }
            this.disablePosition();
            FluidStack ret = this.getFluidHandler().drain(resource, doDrain);
            this.enablePosition();
            return ret;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!this.isNetworkAndPositionValid()) {
                return null;
            }
            this.disablePosition();
            FluidStack ret = this.getFluidHandler().drain(maxDrain, doDrain);
            this.enablePosition();
            return ret;
        }
    }
}

