/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.util;

import de.maxhenkel.gravestone.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class UpdateChecker {
    private IUpdateCheckResult checkResult;
    private int thisVersion;
    private String url;

    public UpdateChecker(IUpdateCheckResult uCheck, int thisVersion, String url) {
        this.checkResult = uCheck;
        this.thisVersion = thisVersion;
        this.url = url;
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UpdateResult result = UpdateChecker.this.checkUpdate(UpdateChecker.this.url);
                UpdateChecker.this.checkResult.onResult(result.isAvailable(), result.getUpdateURL());
            }
        }).start();
    }

    public UpdateResult checkUpdate(String url) {
        String updateURL = new String();
        try {
            URL u = new URL(url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream()));
            String versionString = reader.readLine();
            String urlStr = reader.readLine();
            if (urlStr != null) {
                updateURL = urlStr;
            }
            try {
                int ver = Integer.parseInt(versionString);
                if (ver > this.thisVersion) {
                    return new UpdateResult(true, updateURL);
                }
                return new UpdateResult(false, updateURL);
            }
            catch (NumberFormatException e) {
                Log.e("Failed to parse version ID: " + e.getMessage());
            }
        }
        catch (Exception e) {
            Log.e("Failed to fetch update: " + e.getMessage());
        }
        return new UpdateResult(false, updateURL);
    }

    public static interface IUpdateCheckResult {
        public void onResult(boolean var1, String var2);
    }

    public class UpdateResult {
        private boolean available;
        private String updateURL;

        public UpdateResult(boolean available, String updateURL) {
            this.available = available;
            this.updateURL = updateURL;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public String getUpdateURL() {
            return this.updateURL;
        }
    }
}

