/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.customnpcs;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.customnpcs.CustomNPCsIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerQuestController;

public class NPCQuestTask
extends Task {
    public int npcQuest = 0;
    public boolean checkActive = false;

    public NPCQuestTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return CustomNPCsIntegration.QUEST_TASK;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("npc_quest", this.npcQuest);
        nbt.func_74757_a("check_active", this.checkActive);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.npcQuest = nbt.func_74762_e("npc_quest");
        this.checkActive = nbt.func_74767_n("check_active");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.npcQuest);
        data.writeBoolean(this.checkActive);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.npcQuest = data.readVarInt();
        this.checkActive = data.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("id", () -> this.npcQuest, v -> {
            this.npcQuest = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addBool("check_active", () -> this.checkActive, v -> {
            this.checkActive = v;
        }, false);
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<NPCQuestTask> {
        private Data(NPCQuestTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            return ((NPCQuestTask)this.task).npcQuest > 0 && (((NPCQuestTask)this.task).checkActive ? PlayerQuestController.isQuestActive((EntityPlayer)player, (int)((NPCQuestTask)this.task).npcQuest) : PlayerQuestController.isQuestFinished((EntityPlayer)player, (int)((NPCQuestTask)this.task).npcQuest));
        }
    }
}

