/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.integration.FTBLibJEIIntegration;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.WrappedIngredient;
import com.feed_the_beast.ftblib.lib.gui.misc.CompactGridLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageSubmitTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class GuiValidItems
extends GuiBase {
    public final ItemTask task;
    public final List<ItemStack> validItems;
    public String title = "";
    public final boolean canClick;
    public final Panel itemPanel;
    public final Button backButton;
    public final Button submitButton;

    public GuiValidItems(ItemTask t, List<ItemStack> v, boolean c) {
        this.task = t;
        this.validItems = v;
        this.canClick = c;
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack validItem : GuiValidItems.this.validItems) {
                    this.add((Widget)new ButtonValidItem(this, validItem));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new CompactGridLayout(36));
                this.setHeight(Math.min(160, this.getContentHeight()));
                this.parent.setHeight(this.height + 53);
                int off = (this.width - this.getContentWidth()) / 2;
                for (Widget widget : this.widgets) {
                    widget.setX(widget.posX + off);
                }
                GuiValidItems.this.itemPanel.setX((this.parent.width - this.width) / 2);
                GuiValidItems.this.backButton.setPosAndSize(GuiValidItems.this.itemPanel.posX - 1, this.height + 28, 70, 20);
                GuiValidItems.this.submitButton.setPosAndSize(GuiValidItems.this.itemPanel.posX + 75, this.height + 28, 70, 20);
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawButton(x - 1, y - 1, w + 2, h + 2, WidgetType.NORMAL);
            }
        };
        this.itemPanel.setPosAndSize(0, 22, 144, 0);
        this.backButton = new SimpleTextButton((Panel)this, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiValidItems.this.onBack();
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.submitButton = new SimpleTextButton((Panel)this, "Submit", (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new MessageSubmitTask(GuiValidItems.this.task.id).sendToServer();
                GuiValidItems.this.onBack();
            }

            public void addMouseOverText(List<String> list) {
                if (GuiValidItems.this.canClick && !GuiValidItems.this.task.consumesResources()) {
                    list.add(I18n.func_135052_a((String)"ftbquests.task.auto_detected", (Object[])new Object[0]));
                }
            }

            public WidgetType getWidgetType() {
                return GuiValidItems.this.canClick && GuiValidItems.this.task.consumesResources() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            public boolean renderTitleInCenter() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.title = I18n.func_135052_a((String)"ftbquests.task.ftbquests.item.valid_for", (Object[])new Object[]{this.task.getTitle()});
        this.setWidth(Math.max(156, this.getTheme().getStringWidth(this.title) + 12));
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.backButton);
        this.add((Widget)this.submitButton);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        theme.drawString(this.title, x + w / 2, y + 6, Color4I.WHITE, 4);
    }

    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.onBack();
        }
        return false;
    }

    public class ButtonValidItem
    extends Button {
        public final ItemStack stack;

        public ButtonValidItem(Panel panel, ItemStack is) {
            super(panel, "", ItemIcon.getItemIcon((ItemStack)is));
            this.stack = is;
        }

        public void onClicked(MouseButton button) {
            if (Loader.isModLoaded((String)"jei")) {
                this.showJEIRecipe();
            }
        }

        private void showJEIRecipe() {
            FTBLibJEIIntegration.showRecipe((Object)this.stack);
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient((Object)this.stack).tooltip();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            GuiHelper.drawItem((ItemStack)this.stack, (double)((double)x + 2.0), (double)((double)y + 2.0), (double)2.0, (double)2.0, (boolean)true);
        }
    }
}

