/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectQuestObject
extends GuiButtonListBase {
    private final ConfigQuestObject config;
    private final IOpenableGui callbackGui;
    private final Runnable callback;

    public GuiSelectQuestObject(ConfigQuestObject c, IOpenableGui g, Runnable cb) {
        this.setTitle(I18n.func_135052_a((String)"ftbquests.gui.select_quest_object", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.focus();
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callbackGui = g;
        this.callback = cb;
    }

    public void addButtons(Panel panel) {
        ArrayList<QuestObjectBase> list = new ArrayList<QuestObjectBase>();
        for (QuestObjectBase objectBase : ClientQuestFile.INSTANCE.getAllObjects()) {
            if (!this.config.isValid(objectBase)) continue;
            list.add(objectBase);
        }
        list.sort((o1, o2) -> {
            int i = Integer.compare(o1.getObjectType().ordinal(), o2.getObjectType().ordinal());
            return i == 0 ? o1.getUnformattedTitle().compareToIgnoreCase(o2.getUnformattedTitle()) : i;
        });
        if (this.config.isValid(0)) {
            panel.add((Widget)new ButtonQuestObject(panel, null));
        }
        for (QuestObjectBase objectBase : list) {
            panel.add((Widget)new ButtonQuestObject(panel, objectBase));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public class ButtonQuestObject
    extends SimpleTextButton {
        public final QuestObjectBase object;

        public ButtonQuestObject(@Nullable Panel panel, QuestObjectBase o) {
            super(panel, o == null ? I18n.func_135052_a((String)"ftbquests.null", (Object[])new Object[0]) : o.getObjectType().getColor() + o.getUnformattedTitle(), (Icon)(o == null ? Icon.EMPTY : o.getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        private void addObject(List<String> list, QuestObjectBase o) {
            list.add(TextFormatting.GRAY + o.getObjectType().getDisplayName() + ": " + o.getObjectType().getColor() + o.getUnformattedTitle());
        }

        public void addMouseOverText(List<String> list) {
            if (this.object == null) {
                return;
            }
            list.add(this.object.getTitle());
            list.add(TextFormatting.GRAY + "ID: " + TextFormatting.DARK_GRAY + this.object);
            list.add(TextFormatting.GRAY + "Type: " + this.object.getObjectType().getColor() + I18n.func_135052_a((String)this.object.getObjectType().getTranslationKey(), (Object[])new Object[0]));
            if (this.object instanceof Quest) {
                Quest quest = (Quest)this.object;
                this.addObject(list, quest.chapter);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (Reward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getUnformattedTitle());
                    }
                }
            } else if (this.object instanceof Task) {
                Quest quest = ((Task)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
                if (quest.rewards.size() == 1) {
                    this.addObject(list, quest.rewards.get(0));
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (Reward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getUnformattedTitle());
                    }
                }
            } else if (this.object instanceof Reward) {
                Quest quest = ((Reward)this.object).quest;
                this.addObject(list, quest.chapter);
                this.addObject(list, quest);
            } else if (this.object instanceof RewardTable) {
                ((RewardTable)this.object).addMouseOverText(list, true, true);
            }
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiSelectQuestObject.this.callbackGui.openGui();
            GuiSelectQuestObject.this.config.setObject(QuestObjectBase.getID(this.object));
            GuiSelectQuestObject.this.callback.run();
        }
    }
}

