/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetVerticalSpace;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.IConfigValueEditCallback;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiEditRewardTable
extends GuiButtonListBase {
    private final RewardTable originalTable;
    private final RewardTable rewardTable;
    private final Runnable callback;

    public GuiEditRewardTable(RewardTable r, Runnable c) {
        this.originalTable = r;
        this.rewardTable = new RewardTable(this.originalTable.file);
        NBTTagCompound nbt = new NBTTagCompound();
        this.originalTable.writeData(nbt);
        this.rewardTable.readData(nbt);
        this.callback = c;
        this.setTitle(I18n.func_135052_a((String)"ftbquests.reward_table", (Object[])new Object[0]));
        this.setBorder(1, 1, 1);
    }

    public void addButtons(Panel panel) {
        panel.add((Widget)new ButtonRewardTableSettings(panel));
        panel.add((Widget)new ButtonSaveRewardTable(panel));
        panel.add((Widget)new ButtonAddWeightedReward(panel));
        panel.add((Widget)new WidgetVerticalSpace(panel, 1));
        for (WeightedReward r : this.rewardTable.rewards) {
            panel.add((Widget)new ButtonWeightedReward(panel, r));
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private class ButtonWeightedReward
    extends SimpleTextButton
    implements IConfigValueEditCallback {
        private final WeightedReward reward;

        private ButtonWeightedReward(Panel panel, WeightedReward r) {
            super(panel, r.reward.getTitle(), r.reward.getIcon());
            this.reward = r;
        }

        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            this.reward.reward.addMouseOverText(list);
            list.add(I18n.func_135052_a((String)"ftbquests.reward_table.weight", (Object[])new Object[0]) + ": " + this.reward.weight + TextFormatting.DARK_GRAY + " [" + WeightedReward.chanceString(this.reward.weight, GuiEditRewardTable.this.rewardTable.getTotalWeight(true)) + "]");
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> {
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
                this.reward.reward.getConfig(this.reward.reward.createSubGroup(group));
                new GuiEditConfig(group, IConfigCallback.DEFAULT).openGui();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_table.set_weight", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> new GuiEditConfigValue("value", (ConfigValue)new ConfigInt(this.reward.weight, 1, Integer.MAX_VALUE), (IConfigValueEditCallback)this).openGui()));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> {
                ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.rewards.remove(this.reward);
                GuiEditRewardTable.this.refreshWidgets();
            }).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.reward.reward.getTitle()})));
            GuiEditRewardTable.this.openContextMenu(contextMenu);
        }

        public void onCallback(ConfigValue value, boolean set) {
            this.openGui();
            if (set) {
                this.reward.weight = value.getInt();
            }
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.reward.reward.getIngredient();
        }
    }

    private class ButtonAddWeightedReward
    extends SimpleTextButton {
        private ButtonAddWeightedReward(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), GuiIcons.ADD);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (RewardType type : RewardType.getRegistry()) {
                if (type.getExcludeFromListRewards()) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    type.getGuiProvider().openCreationGui((IOpenableGui)this, ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.fakeQuest, reward -> {
                        ((GuiEditRewardTable)GuiEditRewardTable.this).rewardTable.rewards.add(new WeightedReward((Reward)reward, 1));
                        this.openGui();
                    });
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    private class ButtonSaveRewardTable
    extends SimpleTextButton {
        private ButtonSaveRewardTable(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.closeGui();
            NBTTagCompound nbt = new NBTTagCompound();
            GuiEditRewardTable.this.rewardTable.writeData(nbt);
            GuiEditRewardTable.this.originalTable.readData(nbt);
            GuiEditRewardTable.this.callback.run();
        }
    }

    private class ButtonRewardTableSettings
    extends SimpleTextButton {
        private ButtonRewardTableSettings(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), GuiIcons.SETTINGS);
            this.setHeight(12);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
            GuiEditRewardTable.this.rewardTable.getConfig(GuiEditRewardTable.this.rewardTable.createSubGroup(group));
            new GuiEditConfig(group, IConfigCallback.DEFAULT).openGui();
        }
    }
}

