/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wpt.integration;

import appeng.util.Platform;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.transfer.RecipeTransferErrorTooltip;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.wpt.container.ContainerWPT;
import p455w0rd.wpt.init.ModItems;
import p455w0rd.wpt.init.ModNetworking;
import p455w0rd.wpt.sync.packets.PacketJEIPatternRecipe;
import p455w0rdslib.LibGlobals;

@JEIPlugin
public class JEI
implements IModPlugin {
    private static final IRecipeTransferError NEEDED_MODE_CRAFTING = new IncorrectTerminalModeError(true);
    private static final IRecipeTransferError NEEDED_MODE_PROCESSING = new IncorrectTerminalModeError(false);

    public void register(@Nonnull IModRegistry registry) {
        String wptBaublesDescKey = LibGlobals.Mods.BAUBLES.isLoaded() ? WTApi.instance().getConstants().getTooltips().jeiCanBeWorn() : "";
        registry.addIngredientInfo((List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Item)ModItems.WPT)}), VanillaTypes.ITEM, new String[]{"jei.wpt.desc", wptBaublesDescKey});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new RecipeTransferHandler(), "universal recipe transfer handler");
    }

    private static class IncorrectTerminalModeError
    extends RecipeTransferErrorTooltip {
        private static final String CRAFTING = I18n.func_74837_a((String)"jei.crafting.desc", (Object[])new Object[0]);
        private static final String PROCESSING = I18n.func_74837_a((String)"jei.processing.desc", (Object[])new Object[0]);

        public IncorrectTerminalModeError(boolean needsCrafting) {
            super(I18n.func_74837_a((String)"jei.errormsg.desc", (Object[])new Object[]{TextFormatting.BOLD + (needsCrafting ? CRAFTING : PROCESSING) + TextFormatting.RESET + "" + TextFormatting.RED}));
        }
    }

    public static class RecipeTransferHandler
    implements IRecipeTransferHandler<ContainerWPT> {
        public static final String OUTPUTS_KEY = "Outputs";

        public Class<ContainerWPT> getContainerClass() {
            return ContainerWPT.class;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(ContainerWPT container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
            String recipeType = recipeLayout.getRecipeCategory().getUid();
            if (doTransfer) {
                Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
                NBTTagCompound recipeInputs = new NBTTagCompound();
                NBTTagCompound recipeOutputs = null;
                NBTTagList outputList = new NBTTagList();
                int inputIndex = 0;
                int outputIndex = 0;
                for (Map.Entry ingredientEntry : ingredients.entrySet()) {
                    IGuiIngredient guiIngredient = (IGuiIngredient)ingredientEntry.getValue();
                    if (guiIngredient == null) continue;
                    ItemStack ingredient = ItemStack.field_190927_a;
                    if (guiIngredient.getDisplayedIngredient() != null) {
                        ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
                    }
                    if (guiIngredient.isInput()) {
                        List currentList = guiIngredient.getAllIngredients();
                        ItemStack stack = currentList.isEmpty() ? ItemStack.field_190927_a : (ItemStack)currentList.get(0);
                        for (ItemStack currentStack : currentList) {
                            if (!Platform.isRecipePrioritized((ItemStack)currentStack)) continue;
                            stack = currentStack.func_77946_l();
                        }
                        if (stack == null) {
                            stack = ItemStack.field_190927_a;
                        }
                        recipeInputs.func_74782_a("#" + inputIndex, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
                        ++inputIndex;
                        continue;
                    }
                    if (outputIndex >= 3 || ingredient.func_190926_b() || container.isCraftingMode()) continue;
                    outputList.func_74742_a((NBTBase)ingredient.func_77955_b(new NBTTagCompound()));
                    ++outputIndex;
                }
                if (!outputList.func_82582_d()) {
                    recipeOutputs = new NBTTagCompound();
                    recipeOutputs.func_74782_a(OUTPUTS_KEY, (NBTBase)outputList);
                }
                ModNetworking.instance().sendToServer(new PacketJEIPatternRecipe(recipeInputs, recipeOutputs));
            }
            if (!recipeType.equals("jei.information") && !recipeType.equals("minecraft.fuel")) {
                if (!container.isCraftingMode()) {
                    if (recipeType.equals("minecraft.crafting")) {
                        return NEEDED_MODE_CRAFTING;
                    }
                } else if (!recipeType.equals("minecraft.crafting")) {
                    return NEEDED_MODE_PROCESSING;
                }
            } else {
                return RecipeTransferErrorInternal.INSTANCE;
            }
            return null;
        }
    }
}

