/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wpt.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotInaccessible;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ItemViewCell;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.ae2wtlib.api.container.slot.IOptionalSlotHost;
import p455w0rd.ae2wtlib.api.container.slot.OptionalSlotFake;
import p455w0rd.ae2wtlib.api.container.slot.SlotPatternOutputs;
import p455w0rd.wpt.api.IWPTContainer;
import p455w0rd.wpt.api.IWirelessPatternTerminalItem;
import p455w0rd.wpt.container.slot.SlotCraftingOutput;
import p455w0rd.wpt.container.slot.SlotPatternTerm;
import p455w0rd.wpt.init.ModNetworking;
import p455w0rd.wpt.sync.packets.PacketInventoryAction;
import p455w0rd.wpt.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wpt.sync.packets.PacketPatternSlot;
import p455w0rd.wpt.sync.packets.PacketTargetItemStack;
import p455w0rd.wpt.sync.packets.PacketValueConfig;
import p455w0rd.wpt.util.WPTUtils;

public class ContainerWPT
extends ContainerWT
implements IWPTContainer {
    private final AppEngInternalInventory craftingMatrixOutput = new AppEngInternalInventory(null, 1);
    private final AppEngInternalInventory craftingMatrixInv;
    private final SlotFakeCraftingMatrix[] craftingMatrixSlots = new SlotFakeCraftingMatrix[9];
    private final OptionalSlotFake[] outputSlots = new OptionalSlotFake[3];
    private final SlotPatternTerm craftSlot;
    private final SlotRestrictedInput blankPatternSlot;
    private final SlotRestrictedInput encodedPatternSlot;
    private IRecipe currentRecipe;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;
    private final SlotRestrictedInput[] viewCellSlots = new SlotRestrictedInput[4];
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    private IGridNode networkNode;
    private IAEItemStack clientRequestedTargetItem = null;
    private final AppEngInternalInventory viewCellInv = new AppEngInternalInventory((IAEAppEngInventory)this, 4);
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private final AppEngInternalInventory processingPatternOutputInv = new AppEngInternalInventory((IAEAppEngInventory)this, 3);

    public ContainerWPT(EntityPlayer player, ITerminalHost hostIn, int slot, boolean isBauble) {
        super(player.field_71071_by, (Object)ContainerWPT.getActionHost((Object)ContainerWPT.getGuiObject((ItemStack)(isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, slot, IWirelessPatternTerminalItem.class) : WTApi.instance().getWTBySlot(player, slot)), (EntityPlayer)player)), slot, isBauble, true, 84, -24);
        int i;
        int y;
        this.setCustomName("WPTContainer");
        this.setTerminalHost(hostIn);
        this.initConfig(this.setClientConfigManager((IConfigManager)new ConfigManager((IConfigManagerHost)this)));
        if (Platform.isServer()) {
            this.setServerConfigManager(this.getGuiObject().getConfigManager());
            this.monitor = this.getGuiObject().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler)this.monitor);
                if (this.getGuiObject() instanceof IEnergySource) {
                    this.setPowerSource((IEnergySource)this.getGuiObject());
                } else if (this.getGuiObject() instanceof IGridHost || this.getGuiObject() instanceof IActionHost) {
                    IGrid g;
                    this.networkNode = this.getGuiObject() instanceof IGridHost ? ((IGridHost)this.getGuiObject()).getGridNode(AEPartLocation.INTERNAL) : (this.getGuiObject() instanceof IActionHost ? this.getGuiObject().getActionableNode() : null);
                    if (this.networkNode != null && (g = this.networkNode.getGrid()) != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                    }
                }
            } else {
                this.getPlayer().func_145747_a(PlayerMessages.CommunicationError.get());
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.craftingMatrixInv = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix((IItemHandler)this.craftingMatrixInv, x + y * 3, 8 + x * 18, -84 + y * 18);
                this.craftingMatrixSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.func_75146_a((Slot)slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(player, this.getActionSource(), this.getPowerSource(), (IStorageMonitorable)this.getTerminalHost(), (IItemHandler)this.craftingMatrixInv, (IItemHandler)this.patternInv, (IItemHandler)this.craftingMatrixOutput, 92, -66, this, 2, this);
        this.func_75146_a((Slot)this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs((IItemHandler)this.processingPatternOutputInv, (IOptionalSlotHost)this, y, 92, -84 + y * 18, 0, 0, 1);
            this.func_75146_a((Slot)this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
            this.outputSlots[y].setIIcon(-1);
        }
        this.blankPatternSlot = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, (IItemHandler)this.patternInv, 0, 147, -84, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.blankPatternSlot);
        this.encodedPatternSlot = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IItemHandler)this.patternInv, 1, 147, -41, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.encodedPatternSlot);
        this.encodedPatternSlot.setStackLimit(1);
        for (i = 0; i < this.getPlayerInv().func_70302_i_(); ++i) {
            ItemStack currStack = this.getPlayerInv().func_70301_a(i);
            if (currStack.func_190926_b() || currStack != this.getWirelessTerminal()) continue;
            this.lockPlayerInventorySlot(i);
        }
        for (i = 0; i < 4; ++i) {
            this.viewCellSlots[i] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, this.getViewCellStorage(), i, i * 18 + 8, -24, this.getInventoryPlayer());
            this.func_75146_a((Slot)this.viewCellSlots[i]);
            this.viewCellSlots[i].setAllowEdit(true);
        }
        this.bindPlayerInventory(player.field_71071_by, 8, 0);
        this.updateOrderOfOutputSlots();
        this.readNBT();
    }

    public IItemHandler getViewCellStorage() {
        return this.viewCellInv;
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.craftSlot.field_75223_e = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    public void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.updateOrderOfOutputSlots();
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        World world = this.getPlayerInv().field_70458_d.field_70170_p;
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.craftingMatrixInv.getStackInSlot(x));
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(ic, world)) {
            this.currentRecipe = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)world);
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.field_190927_a : this.currentRecipe.func_77572_b(ic);
        this.craftingMatrixOutput.setStackInSlot(0, is);
        return is;
    }

    public void encode() {
        ItemStack output = this.encodedPatternSlot.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (!output.func_190926_b() && !this.isPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            Optional maybePattern;
            output = this.blankPatternSlot.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.blankPatternSlot.func_75215_d(ItemStack.field_190927_a);
            }
            if ((maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
                output = (ItemStack)maybePattern.get();
                this.encodedPatternSlot.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.isCraftingMode());
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        output.func_77982_d(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingMatrixSlots.length; ++x) {
            input[x] = this.craftingMatrixSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (!out.func_190926_b() && out.func_190916_E() > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
            boolean hasValue = false;
            for (OptionalSlotFake outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.func_75211_c();
                if (out.func_190926_b() || out.func_190916_E() <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[list.size()]);
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
        }
        return c;
    }

    protected void initConfig(IConfigManager cm) {
        cm.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        cm.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        cm.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, IActionSource actionSource) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return !this.isCraftingMode();
        }
        if (idx == 2) {
            return this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PacketPatternSlot packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            AdaptorItemHandler inv = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(this.getPlayerInv()));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((EntityPlayer)this.getPlayerInv().field_70458_d);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).func_190926_b()) {
                return;
            }
            IAEItemStack extracted = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)out, (IActionSource)this.getActionSource());
            EntityPlayer p = this.getPlayerInv().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
                return;
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            InventoryCrafting real = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? ItemStack.field_190927_a : packetPatternSlot.pattern[x].createItemStack());
            }
            IRecipe r = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)p.field_70170_p);
            if (r == null) {
                return;
            }
            IMEMonitor storage = this.getTerminalHost().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList all = storage.getStorageList();
            ItemStack is = r.func_77572_b(ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x).func_190926_b()) continue;
                ItemStack pulled = Platform.extractItemsByRecipe((IEnergySource)this.getPowerSource(), (IActionSource)this.getActionSource(), (IMEMonitor)storage, (World)p.field_70170_p, (IRecipe)r, (ItemStack)is, (InventoryCrafting)ic, (ItemStack)ic.func_70301_a(x), (int)x, (IItemList)all, (Actionable)Actionable.MODULATE, (IPartitionList)ItemViewCell.createFilter((ItemStack[])this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = CraftingManager.func_192413_b((InventoryCrafting)real, (World)p.field_70170_p);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.func_77572_b(real), is)) {
                InventoryCraftResult craftingResult = new InventoryCraftResult();
                craftingResult.func_193056_a(rr);
                SlotCrafting sc = new SlotCrafting(p, real, (IInventory)craftingResult, 0, 0, 0);
                sc.func_190901_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed.func_190926_b()) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed.func_190926_b()) continue;
                    this.getCellInventory().injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)failed), Actionable.MODULATE, this.getActionSource());
                }
            }
        }
    }

    public void onListUpdate() {
        for (IContainerListener c : this.field_75149_d) {
            this.queueInventory(c);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.queueInventory(listener);
    }

    public void readNBT() {
        if (this.getWirelessTerminal().func_77942_o()) {
            NBTTagCompound nbt = this.getWirelessTerminal().func_77978_p();
            this.craftingMatrixInv.readFromNBT(nbt, "PatternCraftingMatrix");
            this.viewCellInv.readFromNBT(nbt, "PatternViewCells");
            this.patternInv.readFromNBT(nbt, "PatternInv");
            this.processingPatternOutputInv.readFromNBT(nbt, "OutputList");
            this.setCraftingRecipe(nbt.func_74767_n("CraftingMode"));
            this.setSubstitution(nbt.func_74767_n("Substitute"));
            super.readNBT();
        }
    }

    public void writeToNBT() {
        if (!this.getWirelessTerminal().func_77942_o()) {
            this.getWirelessTerminal().func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound newNBT = this.getWirelessTerminal().func_77978_p();
        this.craftingMatrixInv.writeToNBT(newNBT, "PatternCraftingMatrix");
        this.patternInv.writeToNBT(newNBT, "PatternInv");
        this.viewCellInv.writeToNBT(newNBT, "PatternViewCells");
        this.processingPatternOutputInv.writeToNBT(newNBT, "OutputList");
        newNBT.func_74757_a("CraftingMode", this.craftingMode);
        newNBT.func_74757_a("Substitute", this.substitute);
        super.writeToNBT();
    }

    public void func_75134_a(EntityPlayer player) {
        this.writeToNBT();
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 4; ++y) {
                if (this.viewCellSlots[y] == null) continue;
                this.viewCellSlots[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingOutput) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingOutput)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand == null) {
                            s.func_75215_d(ItemStack.field_190927_a);
                            break;
                        }
                        s.func_75215_d(hand.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand.func_190926_b()) break;
                        Object is = hand.func_77946_l();
                        is.func_190920_e(1);
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        Object is = s.func_75211_c();
                        if (!is.func_190926_b()) {
                            if (hand.func_190926_b()) {
                                is.func_190920_e(Math.max(1, is.func_190916_E() - 1));
                            } else if (hand.func_77969_a((ItemStack)is)) {
                                is.func_190920_e(Math.min(is.func_77976_d(), is.func_190916_E() + 1));
                            } else {
                                is = hand.func_77946_l();
                                is.func_190920_e(1);
                            }
                            s.func_75215_d((ItemStack)is);
                            break;
                        }
                        if (hand.func_190926_b()) break;
                        is = hand.func_77946_l();
                        is.func_190920_e(1);
                        s.func_75215_d((ItemStack)is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                LinkedList<Slot> from = new LinkedList<Slot>();
                for (Object j : this.field_75151_b) {
                    Slot sl;
                    if (!(j instanceof Slot) || j.getClass() != s.getClass() || (sl = (Slot)j).func_75216_d() && (!sl.func_75216_d() || WPTUtils.isAnyWPT(sl.func_75211_c()))) continue;
                    from.add(sl);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.getTargetStack();
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.createItemStack();
                ais.setStackSize((long)myItem.func_77976_d());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                myItem.func_190920_e((int)ais.getStackSize());
                myItem = adp.simulateAdd(myItem);
                if (!myItem.func_190926_b()) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                }
                if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource())) == null) break;
                adp.addItems(ais.createItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg.func_190926_b()) break;
                IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                if (ais != null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ia.removeItems(1, extracted.createItemStack(), null);
                if (fail.func_190926_b()) {
                    this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (!item.func_190926_b()) {
                    if (item.func_190916_E() >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.itemComparisons().isSameItem(slotItem.createItemStack(), item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                if (ais == null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ia.addItems(ais.createItemStack());
                if (!fail.func_190926_b()) {
                    this.getCellInventory().injectItems((IAEStack)ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o().func_190926_b()) {
                    if (slotItem != null) {
                        IAEItemStack ais = slotItem.copy();
                        ais.setStackSize((long)ais.createItemStack().func_77976_d());
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                        if (ais != null) {
                            player.field_71071_by.func_70437_b(ais.createItemStack());
                        } else {
                            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        }
                        this.updateHeld(player);
                    }
                    return;
                }
                IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)player.field_71071_by.func_70445_o());
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o().func_190926_b()) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getDefinition().func_77976_d();
                    ais.setStackSize(maxSize);
                    ais = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                    }
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.createItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)player.field_71071_by.func_70445_o());
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource());
                if (ais != null) break;
                ItemStack is = player.field_71071_by.func_70445_o();
                is.func_190920_e(is.func_190916_E() - 1);
                if (is.func_190916_E() <= 0) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                ItemStack is = slotItem.createItemStack();
                is.func_190920_e(is.func_77976_d());
                player.field_71071_by.func_70437_b(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.createItemStack();
                    ais.setStackSize((long)myItem.func_77976_d());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    myItem.func_190920_e((int)ais.getStackSize());
                    myItem = adp.simulateAdd(myItem);
                    if (!myItem.func_190926_b()) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
                    }
                    if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), (IMEInventory)this.getCellInventory(), (IAEStack)ais, (IActionSource)this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.createItemStack());
                }
                break;
            }
        }
    }

    public IItemHandler getInventoryByName(String name) {
        switch (name) {
            case "crafting": {
                return this.craftingMatrixInv;
            }
            case "output": {
                return this.processingPatternOutputInv;
            }
        }
        return null;
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetItem == null) {
                return;
            }
            if (stack != null && stack.isSameType(this.clientRequestedTargetItem)) {
                return;
            }
            ModNetworking.instance().sendToServer(new PacketTargetItemStack((AEItemStack)stack));
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnStack = ItemStack.field_190927_a;
        try {
            returnStack = super.func_184996_a(slot, dragType, clickTypeIn, player);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.writeToNBT();
        this.func_75142_b();
        return returnStack;
    }

    private void queueInventory(IContainerListener c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.getGuiObject() != null) {
                if (this.getWirelessTerminal() != this.getGuiObject().getItemStack()) {
                    if (!this.getWirelessTerminal().func_190926_b()) {
                        if (ItemStack.func_179545_c((ItemStack)this.getGuiObject().getItemStack(), (ItemStack)this.getWirelessTerminal())) {
                            this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.getGuiObject().getItemStack());
                        } else {
                            this.setValidContainer(false);
                        }
                    } else {
                        this.setValidContainer(false);
                    }
                }
            } else {
                this.setValidContainer(false);
            }
            if (this.monitor != this.getTerminalHost().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))) {
                this.setValidContainer(false);
            }
            for (Settings set : this.getServerConfigManager().getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.getServerConfigManager().getSetting(set);
                if (sideLocal == (sideRemote = this.getClientConfigManager().getSetting(set))) continue;
                this.getClientConfigManager().putSetting(set, sideLocal);
                for (IContainerListener crafter : this.field_75149_d) {
                    if (!(crafter instanceof EntityPlayerMP)) continue;
                    try {
                        ModNetworking.instance().sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList monitorCache = this.monitor.getStorageList();
                    PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                    for (IAEItemStack is : this.items) {
                        IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendItem(is);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (Object c : this.field_75149_d) {
                            if (!(c instanceof EntityPlayer)) continue;
                            ModNetworking.instance().sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException monitorCache) {
                    // empty catch block
                }
            }
            boolean oldAccessible = this.canAccessViewCells;
            this.canAccessViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 4; ++y) {
                    if (this.viewCellSlots[y] == null) continue;
                    this.viewCellSlots[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.func_75142_b();
            if (!this.isInRange()) {
                if (!this.hasInfiniteRange()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a(PlayerMessages.OutOfRange.get());
                    }
                    this.setValidContainer(false);
                }
                if (!this.networkIsPowered()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a(PlayerMessages.MachineNotPowered.get());
                    }
                    this.setValidContainer(false);
                }
            } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a(PlayerMessages.CommunicationError.get());
                }
                this.setValidContainer(false);
            }
            if (this.getWirelessTerminal().func_77973_b() instanceof IWirelessPatternTerminalItem && ((IWirelessPatternTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal()) <= 0.0) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("No Power"));
                }
                this.setValidContainer(false);
            }
        }
    }

    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalSlotFake) && !(slot instanceof SlotFakeCraftingMatrix)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
        if (s == this.craftSlot && Platform.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingMatrixSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public boolean useRealItems() {
        return false;
    }

    public void toggleSubstitute() {
        this.substitute = !this.substitute;
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.viewCellSlots.length];
        for (int x = 0; x < this.viewCellSlots.length; ++x) {
            list[x] = this.viewCellSlots[x].func_75211_c();
        }
        return list;
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.viewCellSlots[index];
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                ModNetworking.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isPowered() {
        double pwr = ((ICustomWirelessTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal());
        return pwr > 0.0;
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.patternInv && slot == 1) {
            ICraftingPatternItem pattern;
            ICraftingPatternDetails details;
            ItemStack is = this.patternInv.getStackInSlot(1);
            if (!is.func_190926_b() && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getPlayer().func_130014_f_())) != null) {
                IAEItemStack item;
                int x;
                this.setCraftingRecipe(details.isCraftable());
                this.setSubstitution(details.canSubstitute());
                for (x = 0; x < this.craftingMatrixInv.getSlots() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    this.craftingMatrixInv.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
                for (x = 0; x < this.processingPatternOutputInv.getSlots() && x < details.getOutputs().length; ++x) {
                    item = details.getOutputs()[x];
                    this.processingPatternOutputInv.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
            }
        } else if (inv == this.craftingMatrixInv) {
            this.fixCraftingRecipes();
        }
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.craftingMatrixInv.getSlots(); ++x) {
                ItemStack is = this.craftingMatrixInv.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                is.func_190920_e(1);
            }
        }
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (super.func_82846_b(p, idx) == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        AppEngSlot appEngSlot = null;
        ItemStack tis = ItemStack.field_190927_a;
        boolean isAppengSlot = false;
        if (this.field_75151_b.get(idx) instanceof AppEngSlot) {
            isAppengSlot = true;
            appEngSlot = (AppEngSlot)this.field_75151_b.get(idx);
            tis = appEngSlot.func_75211_c();
        }
        if (tis.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (isAppengSlot && appEngSlot != null) {
            if (Platform.isClient()) {
                return ItemStack.field_190927_a;
            }
            boolean hasMETiles = false;
            for (Object is : this.field_75151_b) {
                if (!(is instanceof InternalSlotME)) continue;
                hasMETiles = true;
                break;
            }
            if (hasMETiles) {
                return ItemStack.field_190927_a;
            }
            if (appEngSlot instanceof SlotDisabled || appEngSlot instanceof SlotInaccessible) {
                return ItemStack.field_190927_a;
            }
            if (appEngSlot.func_75216_d()) {
                AppEngSlot cs;
                if ((this.isInInventory(appEngSlot) || this.isInHotbar(appEngSlot)) && tis.func_77973_b() == AEApi.instance().definitions().items().viewCell().maybeItem().get() && this.func_75135_a(tis.func_77946_l(), 54, 58, false)) {
                    if (tis.func_190916_E() > 1) {
                        tis.func_190918_g(1);
                    } else {
                        appEngSlot.clearStack();
                    }
                    return ItemStack.field_190927_a;
                }
                ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
                if (appEngSlot.isPlayerSide()) {
                    tis = this.shiftStoreItem(tis);
                    for (Object e : this.field_75151_b) {
                        if (!(e instanceof AppEngSlot) || (cs = (AppEngSlot)e).isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                        selectedSlots.add(cs);
                    }
                } else {
                    for (Object e : this.field_75151_b) {
                        if (!(e instanceof AppEngSlot) || !(cs = (AppEngSlot)e).isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.func_75214_a(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
                if (selectedSlots.isEmpty() && appEngSlot.isPlayerSide() && !tis.func_190926_b()) {
                    for (Object e : this.field_75151_b) {
                        if (!(e instanceof AppEngSlot)) continue;
                        cs = (AppEngSlot)e;
                        ItemStack destination = cs.func_75211_c();
                        if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                        if (Platform.itemComparisons().isSameItem(destination, tis)) {
                            return ItemStack.field_190927_a;
                        }
                        if (!destination.func_190926_b()) continue;
                        cs.func_75215_d(tis.func_77946_l());
                        cs.func_75218_e();
                        return ItemStack.field_190927_a;
                    }
                }
                if (!tis.func_190926_b()) {
                    int placeAble;
                    for (Slot slot : selectedSlots) {
                        if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d()) continue;
                        ItemStack t = slot.func_75211_c();
                        if (!Platform.itemComparisons().isSameItem(tis, t)) continue;
                        int maxSize = t.func_77976_d();
                        if (maxSize > slot.func_75219_a()) {
                            maxSize = slot.func_75219_a();
                        }
                        placeAble = maxSize - t.func_190916_E();
                        if (tis.func_190916_E() < placeAble) {
                            placeAble = tis.func_190916_E();
                        }
                        t.func_190917_f(placeAble);
                        tis.func_190918_g(placeAble);
                        if (tis.func_190916_E() > 0) continue;
                        appEngSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        return ItemStack.field_190927_a;
                    }
                    for (Slot slot : selectedSlots) {
                        ItemStack tmp;
                        if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                        if (slot.func_75216_d()) {
                            ItemStack t = slot.func_75211_c();
                            if (!Platform.itemComparisons().isSameItem(t, tis)) continue;
                            int maxSize = t.func_77976_d();
                            if (slot.func_75219_a() < maxSize) {
                                maxSize = slot.func_75219_a();
                            }
                            placeAble = maxSize - t.func_190916_E();
                            if (tis.func_190916_E() < placeAble) {
                                placeAble = tis.func_190916_E();
                            }
                            t.func_190917_f(placeAble);
                            tis.func_190918_g(placeAble);
                            if (tis.func_190916_E() > 0) continue;
                            appEngSlot.func_75215_d(ItemStack.field_190927_a);
                            slot.func_75218_e();
                            return ItemStack.field_190927_a;
                        }
                        int maxSize = tis.func_77976_d();
                        if (maxSize > slot.func_75219_a()) {
                            maxSize = slot.func_75219_a();
                        }
                        if ((tmp = tis.func_77946_l()).func_190916_E() > maxSize) {
                            tmp.func_190920_e(maxSize);
                        }
                        tis.func_190918_g(tmp.func_190916_E());
                        slot.func_75215_d(tmp);
                        if (tis.func_190916_E() > 0) continue;
                        appEngSlot.func_75215_d(ItemStack.field_190927_a);
                        slot.func_75218_e();
                        return ItemStack.field_190927_a;
                    }
                }
                appEngSlot.func_75215_d(!tis.func_190926_b() ? tis.func_77946_l() : ItemStack.field_190927_a);
                appEngSlot.func_75218_e();
            }
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.getGuiObject() == null) {
            return input;
        }
        IEnergySource pwr = this.getPowerSource();
        WTGuiObject guiobj = this.getGuiObject();
        IActionSource act = this.getActionSource();
        IItemStorageChannel chan = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IAEItemStack aestack = (IAEItemStack)chan.createStack((Object)input);
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)pwr, (IMEInventory)guiobj, (IAEStack)aestack, (IActionSource)act);
        if (ais == null) {
            return ItemStack.field_190927_a;
        }
        return ais.createItemStack();
    }
}

