/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileCreativeChest
extends XUTile
implements IDynamicHandler {
    public NBTSerializable.NBTStack heldStack = this.registerNBT("held_stack", new NBTSerializable.NBTStack());
    public IItemHandler handler = new IItemHandlerModifiableCompat(){

        @Override
        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
        }

        @Override
        public int getSlots() {
            return 1;
        }

        @Override
        @ItemStackNonNull
        public ItemStack getStackInSlot(int slot) {
            ItemStack raw = TileCreativeChest.this.heldStack.getRaw();
            if (StackHelper.isNull(raw)) {
                return StackHelper.empty();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)raw, (int)raw.func_77976_d());
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack raw = TileCreativeChest.this.heldStack.getRaw();
            if (StackHelper.isNull(raw)) {
                return StackHelper.empty();
            }
            return TileCreativeChest.this.heldStack.getCopy(Math.min(amount, raw.func_77976_d()));
        }
    };

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.handler;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCreativeChest(this, player);
    }

    public static class ContainerCreativeChest
    extends DynamicContainerTile {
        public ContainerCreativeChest(final TileCreativeChest tileCreativeChest, final EntityPlayer player) {
            super(tileCreativeChest);
            this.addTitle(Lang.getItemName((Block)XU2Entries.creativeChest.value));
            this.crop();
            int arrow_w = 11;
            this.addWidget(new WidgetProgressArrowBase(85 - arrow_w, this.height));
            this.addWidget(new WidgetSlotItemHandler(new SingleStackHandlerBase(){

                @Override
                @ItemStackNonNull
                public ItemStack getStack() {
                    ItemStack raw = tileCreativeChest.heldStack.getRaw();
                    if (StackHelper.isNull(raw)) {
                        return StackHelper.empty();
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)raw, (int)raw.func_77976_d());
                }

                @Override
                public void setStack(@ItemStackNonNull ItemStack stack) {
                    tileCreativeChest.heldStack.setStackRaw(stack);
                }
            }, 0, 85 - arrow_w - 4 - 18, this.height){

                public boolean func_75214_a(ItemStack stack) {
                    return ContainerCreativeChest.isCreativeMode(player) && super.func_75214_a(stack);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return ContainerCreativeChest.isCreativeMode(player) && super.func_82869_a(playerIn);
                }

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    if (!ContainerCreativeChest.isCreativeMode(player)) {
                        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                    gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 0, 18, 18);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
            });
            this.addWidget(new WidgetSlotItemHandler(tileCreativeChest.handler, 0, 85 + arrow_w + 4, this.height){

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }

                public int func_178170_b(ItemStack stack) {
                    return 0;
                }

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    if (!this.func_75216_d()) {
                        GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
                    }
                    gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 0, 18, 18);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
            });
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        private static boolean isCreativeMode(EntityPlayer player) {
            return ExtraUtils2.allowNonCreativeConfig || player.field_71075_bZ.field_75098_d;
        }
    }
}

