/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.rwtema.extrautils2.quarry.BlockDummy;
import com.rwtema.extrautils2.utils.LogHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BlockBreakingRegistry {
    public static final BlockBreakingRegistry instance = new BlockBreakingRegistry();
    public static final HashMap<Block, entry> entries = new HashMap();
    public static final Set<String> methodNames;
    public static final Map<String, Boolean> names;
    public static final LaunchClassLoader cl;

    public static boolean blackList(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).blackList;
    }

    public static boolean isSpecial(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isSpecial;
    }

    public static boolean isFence(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isFence;
    }

    public static boolean isFluid(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isFluid;
    }

    public void setupBreaking() {
    }

    public boolean hasSpecialBreaking(Class clazz) {
        if (clazz == null || clazz.equals(Block.class)) {
            return false;
        }
        if (clazz == BlockCommandBlock.class) {
            return true;
        }
        if (clazz == BlockStructure.class) {
            return true;
        }
        if (clazz == BlockStructureVoid.class) {
            return true;
        }
        if (names.containsKey(clazz.getName())) {
            return names.get(clazz.getName());
        }
        LogHelper.fine("Checking class for special block breaking code: " + clazz.getName(), new Object[0]);
        try {
            byte[] bytes = clazz.getClassLoader() instanceof LaunchClassLoader ? ((LaunchClassLoader)clazz.getClassLoader()).getClassBytes(clazz.getName()) : cl.getClassBytes(clazz.getName());
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!methodNames.contains(method.name)) continue;
                LogHelper.fine("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                names.put(clazz.getName(), true);
                return true;
            }
        }
        catch (Throwable e) {
            try {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!methodNames.contains(m.getName())) continue;
                    LogHelper.fine("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                    names.put(clazz.getName(), true);
                    return true;
                }
            }
            catch (Throwable e2) {
                LogHelper.error("Error checking block class code: " + clazz.getName(), new Object[0]);
                e.printStackTrace();
                e2.printStackTrace();
                names.put(clazz.getName(), true);
                return true;
            }
        }
        boolean result = this.hasSpecialBreaking(clazz.getSuperclass());
        names.put(clazz.getName(), result);
        return result;
    }

    static {
        names = new HashMap<String, Boolean>();
        cl = (LaunchClassLoader)BlockBreakingRegistry.class.getClassLoader();
        methodNames = new HashSet<String>();
        for (Method m : BlockDummy.class.getDeclaredMethods()) {
            methodNames.add(m.getName());
        }
    }

    public static class entry {
        public boolean isSpecial = false;
        public boolean blackList = false;
        public boolean isFence = false;
        public boolean isFluid = false;
    }
}

