/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;

public class BlockTallSlimeGrass
extends BlockBush
implements IShearable {
    public static PropertyEnum<SlimePlantType> TYPE = PropertyEnum.func_177709_a((String)"type", SlimePlantType.class);
    public static PropertyEnum<BlockSlimeGrass.FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

    public BlockTallSlimeGrass() {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (SlimePlantType type : SlimePlantType.values()) {
            for (BlockSlimeGrass.FoliageType foliage : BlockSlimeGrass.FoliageType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a(FOLIAGE, (Comparable)((Object)foliage)))));
            }
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FOLIAGE});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((SlimePlantType)((Object)state.func_177229_b(TYPE))).getMeta();
        return meta |= ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(FOLIAGE))).ordinal() << 2;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int foliage;
        int type = meta & 3;
        if (type >= SlimePlantType.values().length) {
            type = 0;
        }
        if ((foliage = meta >> 2) >= BlockSlimeGrass.FoliageType.values().length) {
            foliage = 0;
        }
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a(TYPE, (Comparable)((Object)SlimePlantType.values()[type]));
        state = state.func_177226_a(FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.values()[foliage]));
        return state;
    }

    public boolean func_176200_f(IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        int meta = this.func_176201_c(state);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        Block ground = soil.func_177230_c();
        return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return TinkerWorld.slimePlantType;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    public static enum SlimePlantType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TALL_GRASS,
        FERN;

        public final int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

