/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class EnergyReceptor {
    @Nonnull
    private final IPowerInterface receptor;
    @Nonnull
    private final EnumFacing fromDir;
    @Nonnull
    private final IoMode mode;
    private final BlockPos location;
    private final IPowerConduit conduit;

    public EnergyReceptor(@Nonnull TileCapBank cb, @Nonnull IPowerInterface receptor, @Nonnull EnumFacing dir) {
        this.receptor = receptor;
        this.fromDir = dir;
        this.mode = cb.getIoMode(dir);
        this.conduit = receptor.getProvider() instanceof IConduitBundle ? ((IConduitBundle)receptor.getProvider()).getConduit(IPowerConduit.class) : null;
        this.location = cb.getLocation();
    }

    public IPowerConduit getConduit() {
        return this.conduit;
    }

    @Nonnull
    public IPowerInterface getReceptor() {
        return this.receptor;
    }

    @Nonnull
    public EnumFacing getDir() {
        return this.fromDir;
    }

    @Nonnull
    public IoMode getMode() {
        return this.mode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromDir.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnergyReceptor other = (EnergyReceptor)obj;
        if (this.fromDir != other.fromDir) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals((Object)other.location));
    }

    public String toString() {
        return "EnergyReceptor [receptor=" + this.receptor + ", fromDir=" + this.fromDir + ", mode=" + (Object)((Object)this.mode) + ", conduit=" + this.conduit + "]";
    }
}

