/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.transceiver.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.ColorUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.machines.machine.transceiver.gui.GuiTransceiver;
import java.awt.Color;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;

public class GuiChannelList
extends GuiScrollableList<Channel> {
    private FluentIterable<Channel> channels;
    @Nonnull
    private final GuiTransceiver parent;

    public GuiChannelList(@Nonnull GuiTransceiver parent, int width, int height, int originX, int originY) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.parent = parent;
    }

    void setChannels(Set<Channel> val, Predicate<Channel> filter) {
        if (val == null) {
            this.channels = FluentIterable.from((Iterable)Sets.newHashSet());
        } else {
            this.channels = FluentIterable.from(val);
            if (filter != null) {
                this.channels = this.channels.filter(filter);
            }
        }
    }

    public int getNumElements() {
        return this.channels.size();
    }

    @Nonnull
    public Channel getElementAt(int index) {
        if (index < 0 || index >= this.channels.size()) {
            throw new IndexOutOfBoundsException("No channel for index " + index);
        }
        return (Channel)this.channels.get(index);
    }

    protected void drawElement(int index, int xPosition, int yPosition, int rowHeight, @Nonnull BufferBuilder renderer) {
        if (index < 0 || index >= this.channels.size()) {
            return;
        }
        Channel c = this.getElementAt(index);
        int col = ColorUtil.getRGB((Color)Color.white);
        this.parent.func_73731_b(this.parent.getFontRenderer(), c.getName(), xPosition + this.margin, yPosition + this.margin / 2, col);
        if (!c.isPublic()) {
            IconEIO.map.render((IWidgetIcon)IconEIO.LOCK_LOCKED, (double)(xPosition + this.width - 18), (double)(yPosition - 3), 16.0, 15.0, 0.0, true);
        }
    }
}

