/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.solar;

import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.base.init.RegisterModObject;
import crazypants.enderio.machines.config.config.SolarConfig;
import crazypants.enderio.machines.machine.solar.ISolarType;
import info.loenwind.autoconfig.factory.IValue;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiomachines")
public class SolarType
implements ISolarType {
    @Nonnull
    public static final SolarType SIMPLE = new SolarType("SIMPLE", ".simple");
    @Nonnull
    public static final SolarType NORMAL = new SolarType("NORMAL", "");
    @Nonnull
    public static final SolarType ADVANCED = new SolarType("ADVANCED", ".advanced");
    @Nonnull
    public static final SolarType VIBRANT = new SolarType("VIBRANT", ".vibrant"){

        @Override
        public boolean hasParticles() {
            return true;
        }

        @Override
        @Nonnull
        public Vector3d getParticleColor() {
            return new Vector3d(0.2784313725490196, 0.6235294117647059, 0.6392156862745098);
        }
    };
    @Nonnull
    public static final SolarType COMPRESSED = new SolarType("COMPRESSED", ".compressed"){

        @Override
        public boolean hasParticles() {
            return true;
        }

        @Override
        @Nonnull
        public Vector3d getParticleColor() {
            return new Vector3d(0.8352941176470589, 0.35294117647058826, 0.35294117647058826);
        }
    };
    @Nonnull
    public static final SolarType CONCENTRATED = new SolarType("CONCENTRATED", ".concentrated"){

        @Override
        public boolean hasParticles() {
            return true;
        }

        @Override
        @Nonnull
        public Vector3d getParticleColor() {
            return new Vector3d(0.00392156862745098, 0.00392156862745098, 0.00392156862745098);
        }
    };
    @Nonnull
    public static final SolarType ULTIMATE = new SolarType("ULTIMATE", ".ultimate"){

        @Override
        public boolean hasParticles() {
            return true;
        }

        @Override
        @Nonnull
        public Vector3d getParticleColor() {
            return new Vector3d(1.0, 1.0, 1.0);
        }
    };
    @Nonnull
    private final String name;
    @Nonnull
    private final String unlocalisedName;

    @SubscribeEvent
    public static void registerRegistry(@Nonnull RegisterModObject event) {
    }

    private SolarType(@Nonnull String name, @Nonnull String unlocalisedName) {
        this.name = (String)NullHelper.notnullJ((Object)name.toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
        this.unlocalisedName = unlocalisedName;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Override
    public int getRfperTick() {
        return (Integer)((IValue)SolarConfig.blockGen.get(ISolarType.getMetaFromType(this))).get();
    }

    @Override
    public int getRfperSecond() {
        return (Integer)((IValue)SolarConfig.upgradeGen.get(ISolarType.getMetaFromType(this))).get();
    }

    @Override
    public int getUpgradeLevelCost() {
        return (Integer)((IValue)SolarConfig.upgradeCost.get(ISolarType.getMetaFromType(this))).get();
    }

    static {
        KIND.addValue(SIMPLE);
        KIND.addValue(NORMAL);
        KIND.addValue(ADVANCED);
        KIND.addValue(VIBRANT);
        if (Loader.isModLoaded((String)"enderioendergy")) {
            KIND.addValue(COMPRESSED);
            KIND.addValue(CONCENTRATED);
            KIND.addValue(ULTIMATE);
        }
    }
}

