/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.base;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.obelisk.base.AbstractRangedObeliskEntity;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

@Storable
public abstract class AbstractMobObeliskEntity
extends AbstractRangedObeliskEntity
implements EntityAction.Implementer,
INotifier {
    public AbstractMobObeliskEntity(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        return CapturedMob.containsSoul(itemstack);
    }

    @Override
    public boolean isActive() {
        return this.redstoneCheckPassed && this.hasPower();
    }

    protected boolean isMobInRange(EntityLivingBase mob) {
        return mob != null && this.getBounds().func_72318_a(new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v));
    }

    @Override
    public boolean canWork() {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            if (!Prep.isValid(this.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isMobInFilter(EntityLivingBase entity) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.getStackInSlot(i));
            if (mob == null || !mob.isSameType((Entity)entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public NNList<CapturedMob> getEntities() {
        NNList result = new NNList();
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.getStackInSlot(i));
            if (mob == null) continue;
            result.add((Object)mob);
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<? extends ILocalizable> getNotification() {
        return this.canWork() ? Collections.emptySet() : Collections.singleton(new ILocalizable(){

            @Override
            @Nonnull
            public String getUnlocalizedName() {
                return Lang.GUI_OBELISK_NO_VIALS.getKey();
            }
        });
    }
}

