/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.killera;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.gui.GuiMachineBase;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machines.machine.killera.TileKillerJoe;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiKillerJoe
extends GuiMachineBase<TileKillerJoe> {
    @Nonnull
    private static final Rectangle RECTANGLE_FUEL_TANK = new Rectangle(18, 11, 15, 47);
    @Nonnull
    private final ToggleButton showRangeB;

    public GuiKillerJoe(@Nonnull InventoryPlayer inventory, final @Nonnull TileKillerJoe tileEntity) {
        super(tileEntity, (Container)new ContainerKillerJoe(inventory, tileEntity), new String[]{"killer_joe"});
        this.addToolTip(new GuiToolTip(RECTANGLE_FUEL_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_JOE_FTANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileKillerJoe)((GuiKillerJoe)GuiKillerJoe.this).getTileEntity()).tank));
                if (tileEntity.tank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(Lang.GUI_JOE_MINREQ.get(LangFluid.MB(tileEntity.getActivationAmount())));
                }
            }
        });
        int spacing = 5;
        int bw = 16;
        int x = 81;
        x += spacing + bw;
        x += spacing + bw;
        x = this.getXSize() - 5 - 16;
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, x, 44, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            @Nonnull
            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{(GuiKillerJoe.this.showRangeB.isSelected() ? Lang.GUI_HIDE_RANGE : Lang.GUI_SHOW_RANGE).get()});
            }
        });
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_FUEL_TANK.contains(mouseX, mouseY)) {
            return ((TileKillerJoe)this.getTileEntity()).tank.getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TileKillerJoe)this.getTileEntity()).isShowingRange());
        ((ContainerKillerJoe)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    protected void func_146284_a(@Nonnull GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b == this.showRangeB) {
            ((TileKillerJoe)this.getTileEntity()).setShowRange(this.showRangeB.isSelected());
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(@Nonnull IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 16;
            int y = 9;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = this.field_147003_i + 18;
        int y = this.field_147009_r + 11;
        TileKillerJoe joe = (TileKillerJoe)this.getTileEntity();
        if (!joe.tank.isEmpty()) {
            RenderUtil.renderGuiTank((FluidStack)joe.tank.getFluid(), (int)joe.tank.getCapacity(), (int)joe.tank.getFluidAmount(), (double)x, (double)y, (double)this.field_73735_i, (double)16.0, (double)47.0);
        }
        super.func_146976_a(par1, par2, par3);
    }
}

