/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.config;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.invpanel.config.Config;
import crazypants.enderio.invpanel.remote.ItemRemoteInvAccessType;
import info.loenwind.autoconfig.factory.IValue;
import info.loenwind.autoconfig.factory.IValueFactory;
import java.util.ArrayList;
import java.util.List;

public final class InvpanelConfig {
    public static final IValueFactory F = Config.F.section("invpanel");
    public static final IValue<Boolean> inventoryPanelFree = F.make("inventoryPanelFree", Boolean.valueOf(false), "If true, the inv panel will not accept fluids and will be active permanently.").sync();
    public static final IValue<Float> inventoryPanelPowerPerMB = F.make("inventoryPanelPowerPerMB", 800.0f, "Internal power generated per mB. The default of 800/mB matches the RF generation of the Zombie generator. A panel tries to refill only once every second - setting this value too low slows down the scanning speed.").sync().setMin(1.0);
    public static final IValue<Float> inventoryPanelScanCostPerSlot = F.make("inventoryPanelScanCostPerSlot", 0.1f, "Internal power used for scanning a slot").sync().setMin(0.0);
    public static final IValue<Float> inventoryPanelExtractCostPerItem = F.make("inventoryPanelExtractCostPerItem", 12.0f, "Internal power used per item extracted (not a stack of items)").sync().setMin(0.0);
    public static final IValue<Float> inventoryPanelExtractCostPerOperation = F.make("inventoryPanelExtractCostPerOperation", 32.0f, "Internal power used per extract operation (independent of stack size)").sync().setMin(0.0);
    public static final IValue<Boolean> inventoryPanelScaleText = F.make("inventoryPanelScaleText", Boolean.valueOf(true), "If true stack sizes will be drawn at a smaller size with a little more detail.");
    public static final List<IValue<Integer>> remoteInventoryMBPerOpen = new ArrayList<IValue<Integer>>();
    public static final List<IValue<Integer>> remoteInventoryRFPerTick = new ArrayList<IValue<Integer>>();
    public static final List<IValue<Integer>> remoteInventoryMBCapacity = new ArrayList<IValue<Integer>>();
    public static final List<IValue<Integer>> remoteInventoryRFCapacity = new ArrayList<IValue<Integer>>();
    public static final List<IValue<String>> remoteInventoryFluidTypes = new ArrayList<IValue<String>>();
    private static final int[] DEF_MB_OPEN = new int[]{100, 25, 15};
    private static final int[] DEF_RF_TICK = new int[]{4, 6, 8};
    private static final int[] DEF_MB_CAP = new int[]{2000, 1000, 1500};
    private static final int[] DEF_RF_CAP = new int[]{60000, 120000, 150000};
    private static final String[] DEF_FLUID = new String[]{"nutrient_distillation", "ender_distillation", "vapor_of_levity"};
    public static final IValue<Boolean> respectsGravity;

    static {
        for (ItemRemoteInvAccessType type : ItemRemoteInvAccessType.values()) {
            int i = type.ordinal();
            remoteInventoryMBPerOpen.add((IValue<Integer>)F.make("remoteInventoryMBPerOpenTier" + i, DEF_MB_OPEN[i], "MB required to open the panel").sync().setMin(0.0));
            remoteInventoryRFPerTick.add((IValue<Integer>)F.make("remoteInventoryRFPerTickTier" + i, DEF_RF_TICK[i], "RF used per tick when the panel is open").sync().setMin(0.0));
            remoteInventoryMBCapacity.add((IValue<Integer>)F.make("remoteInventoryMBCapacityTier" + i, DEF_MB_CAP[i], "Capacity of the internal tank in MB").sync().setMin(0.0));
            remoteInventoryRFCapacity.add((IValue<Integer>)F.make("remoteInventoryRFCapacityTier" + i, DEF_RF_CAP[i], "Capacity of the internal energy storage").sync().setMin(0.0));
            remoteInventoryFluidTypes.add((IValue<String>)F.make("remoteInventoryFluidTypesTier" + i, (String)NullHelper.notnull((Object)DEF_FLUID[i], (String)"DEF_FLUID"), "The type of fluid required").sync());
        }
        respectsGravity = F.make("respectsGravity", Boolean.valueOf(true), "If true, the inv panel will respect gravity and fall like an anvil when not attached to a block.").sync();
    }
}

