/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class CompositeList<E>
extends AbstractList<E> {
    @Nonnull
    private final List<E> list1;
    @Nonnull
    private final List<E> list2;

    public CompositeList(@Nonnull List<E> list1, @Nonnull List<E> list2) {
        this.list1 = list1;
        this.list2 = list2;
    }

    @Nonnull
    public static <E> List<E> create(List<E> list1, List<E> list2) {
        if (list1 == null || list1.isEmpty()) {
            if (list2 == null || list2.isEmpty()) {
                return Collections.emptyList();
            }
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list1;
        }
        return new CompositeList<E>(list1, list2);
    }

    @Override
    public E get(int index) {
        if (index < this.list1.size()) {
            return this.list1.get(index);
        }
        return this.list2.get(index - this.list1.size());
    }

    @Override
    public int size() {
        return this.list1.size() + this.list2.size();
    }
}

