/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.painter;

import crazypants.enderio.base.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.base.paint.PaintSourceValidator;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HelmetPainterTemplate
extends AbstractPainterTemplate<ItemDarkSteelArmor> {
    @Nonnull
    private final ItemDarkSteelArmor helmet;

    public HelmetPainterTemplate(@Nonnull ItemDarkSteelArmor helmet) {
        this.helmet = helmet;
        PaintUtil.registerPaintable(new Item[]{helmet});
    }

    @Override
    public boolean isValidTarget(@Nonnull ItemStack target) {
        return target.func_77973_b() == this.helmet;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] produceCompletedResult(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(target) || Prep.isInvalid(paintSource)) {
            return new IMachineRecipe.ResultStack[0];
        }
        if (this.isValidTarget(paintSource)) {
            ItemStack result = target.func_77946_l();
            NBTTagCompound tagCompound = result.func_77978_p();
            if (tagCompound != null) {
                tagCompound.func_82580_o("DSPAINT");
            }
            PaintUtil.setPaintSource(result, Prep.getEmpty());
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
        }
        if (paintSource.func_77973_b() instanceof ItemBlock) {
            ItemStack result = target.func_77946_l();
            NBTTagCompound tagCompound = result.func_77978_p();
            if (tagCompound != null) {
                tagCompound.func_82580_o("DSPAINT");
            }
            PaintUtil.setPaintSource(result, paintSource);
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
        }
        return new IMachineRecipe.ResultStack[0];
    }

    @Override
    public boolean isRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        return this.isValidTarget(target) && this.isValidPaint(paintSource);
    }

    @Override
    public boolean isPartialRecipe(@Nonnull ItemStack paintSource, @Nonnull ItemStack target) {
        if (Prep.isInvalid(paintSource)) {
            return this.isValidTarget(target);
        }
        if (Prep.isInvalid(target)) {
            return this.isValidPaint(paintSource);
        }
        return this.isValidTarget(target) && this.isValidPaint(paintSource);
    }

    protected boolean isValidPaint(@Nonnull ItemStack paintSource) {
        return Prep.isValid(paintSource) && (paintSource.func_77973_b() instanceof ItemBlock && PaintSourceValidator.instance.isValidSourceDefault(paintSource) || this.isValidTarget(paintSource));
    }

    @Override
    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return this.isValidPaint(input.item);
        }
        return false;
    }

    @Override
    protected void registerTargetsWithTooltipProvider() {
    }
}

