/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.lookup;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.lookup.RecipeLeafNode;
import crazypants.enderio.base.recipe.lookup.RecipeNode;
import crazypants.enderio.util.FuncUtil;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TriLookup<REC, LOB1, LID1, LOB2, LID2, LOB3, LID3> {
    @Nonnull
    private final Function<LOB1, LID1> toId1;
    @Nonnull
    private final Function<LOB2, LID2> toId2;
    @Nonnull
    private final Function<LOB3, LID3> toId3;
    @Nonnull
    private final RecipeNode<REC, LOB1, LID1, RecipeNode<REC, LOB2, LID2, RecipeLeafNode<REC, LOB3, LID3>>> root;

    public TriLookup(@Nonnull Function<LOB1, LID1> toId1, @Nonnull Function<LOB2, LID2> toId2, @Nonnull Function<LOB3, LID3> toId3) {
        this.toId1 = toId1;
        this.toId2 = toId2;
        this.toId3 = toId3;
        this.root = this.makeNode1();
    }

    @Nonnull
    private RecipeNode<REC, LOB1, LID1, RecipeNode<REC, LOB2, LID2, RecipeLeafNode<REC, LOB3, LID3>>> makeNode1() {
        return new RecipeNode(this.toId1);
    }

    @Nonnull
    private RecipeNode<REC, LOB2, LID2, RecipeLeafNode<REC, LOB3, LID3>> makeNode2() {
        return new RecipeNode(this.toId2);
    }

    @Nonnull
    private RecipeLeafNode<REC, LOB3, LID3> makeNode3() {
        return new RecipeLeafNode(this.toId3);
    }

    public void addRecipe(@Nonnull REC recipe, @Nonnull LOB1 key1, @Nonnull LOB2 key2, @Nonnull LOB3 key3) {
        this.root.makeNext(recipe, key1, this::makeNode2).makeNext(recipe, key2, this::makeNode3).addRecipe(recipe, key3);
    }

    public void addRecipe(@Nonnull REC recipe, @Nonnull LOB1 key1, @Nonnull LOB2 key2) {
        this.root.makeNext(recipe, key1, this::makeNode2).makeNext(recipe, key2, this::makeNode3);
    }

    public void addRecipe(@Nonnull REC recipe, @Nonnull LOB1 key1) {
        this.root.makeNext(recipe, key1, this::makeNode2);
    }

    @Nonnull
    public NNList<REC> getRecipes(@Nonnull LOB1 key1, @Nonnull LOB2 key2, @Nonnull LOB3 key3) {
        return FuncUtil.runIfOrSupNN(this.root.getNext(key1), r2 -> FuncUtil.runIf(r2.getNext(key2), r3 -> r3.getRecipes(key3)), () -> NNList.emptyList());
    }

    @Nonnull
    public NNList<REC> getRecipes(@Nonnull LOB1 key1, @Nonnull LOB2 key2) {
        return FuncUtil.runIfOrSupNN(this.root.getNext(key1), r2 -> r2.getRecipes(key2), () -> NNList.emptyList());
    }

    @Nonnull
    public NNList<REC> getRecipes(@Nonnull LOB1 key1) {
        return this.root.getRecipes(key1);
    }
}

