/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class MachineRecipeRegistry {
    @Nonnull
    public static final String PAINTER = "painter";
    @Nonnull
    public static final String SAGMILL = "sagmill";
    @Nonnull
    public static final String ALLOYSMELTER = "alloysmelter";
    @Nonnull
    public static final String SLICENSPLICE = "slicensplice";
    @Nonnull
    public static final String SOULBINDER = "soulbinder";
    @Nonnull
    public static final String VAT = "vat";
    @Nonnull
    public static final String SPAWNER = "spawner";
    @Nonnull
    public static final String FARM = "farmingstation";
    @Nonnull
    public static final String TRANSCEIVER = "transceiver";
    @Nonnull
    public static final String ENCHANTER = "enchanter";
    @Nonnull
    public static final String TANK_FILLING = "tankfill";
    @Nonnull
    public static final String TANK_EMPTYING = "tankempty";
    @Nonnull
    public static final MachineRecipeRegistry instance = new MachineRecipeRegistry();
    private final Map<String, RecipeGroupHolder<?>> machineRecipes = new HashMap();

    public void registerRecipe(@Nonnull IMachineRecipe recipe) {
        this.getRecipeHolderssForMachine(recipe.getMachineName()).addRecipe(recipe);
    }

    @Deprecated
    public void registerRecipe(@Nonnull String machine, @Nonnull IMachineRecipe recipe) {
        this.getRecipeHolderssForMachine(machine).addRecipe(recipe);
    }

    public boolean removeRecipe(@Nonnull IMachineRecipe recipe) {
        return this.getRecipeHolderssForMachine(recipe.getMachineName()).removeRecipe(recipe);
    }

    @Nonnull
    public Map<String, ? extends IMachineRecipe> getRecipesForMachine(@Nonnull String machineName) {
        return this.getRecipeHolderssForMachine(machineName).getRecipesForMachine();
    }

    @Nonnull
    public RecipeGroupHolder<?> getRecipeHolderssForMachine(@Nonnull String machineName) {
        return (RecipeGroupHolder)NullHelper.notnullJ((Object)this.machineRecipes.computeIfAbsent(machineName, unused -> new SimpleRecipeGroupHolder(false)), (String)"map.computeIfAbsent");
    }

    public void enableRecipeSorting(@Nonnull String machineName) {
        RecipeGroupHolder<?> res = this.machineRecipes.get(machineName);
        if (res instanceof SimpleRecipeGroupHolder) {
            this.machineRecipes.put(machineName, ((SimpleRecipeGroupHolder)res).asSorted());
            return;
        }
        throw new RuntimeException("Cannot force recipe sorting for " + res + " of machine " + machineName);
    }

    public IMachineRecipe getRecipeForUid(@Nonnull String uid) {
        for (RecipeGroupHolder<?> holder : this.machineRecipes.values()) {
            Object recipe = holder.getRecipeForUid(uid);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public IMachineRecipe getRecipeForInputs(@Nonnull RecipeLevel machineLevel, @Nonnull String machineName, @Nonnull NNList<MachineRecipeInput> inputs) {
        return this.getRecipeHolderssForMachine(machineName).getRecipeForInputs(machineLevel, machineName, inputs);
    }

    public IMachineRecipe getRecipeForInput(@Nonnull RecipeLevel machineLevel, @Nonnull String machineName, @Nonnull MachineRecipeInput input) {
        return this.getRecipeHolderssForMachine(machineName).getRecipeForInput(machineLevel, machineName, input);
    }

    private static class SimpleRecipeGroupHolder
    implements RecipeGroupHolder<IMachineRecipe> {
        @Nonnull
        private final Map<String, IMachineRecipe> recipes;

        public SimpleRecipeGroupHolder(boolean sorted) {
            this.recipes = sorted ? new TreeMap<String, IMachineRecipe>() : new LinkedHashMap<String, IMachineRecipe>();
        }

        public SimpleRecipeGroupHolder asSorted() {
            SimpleRecipeGroupHolder result = new SimpleRecipeGroupHolder(true);
            result.recipes.putAll(this.recipes);
            return result;
        }

        @Override
        public void addRecipe(@Nonnull IMachineRecipe recipe) {
            this.recipes.put(recipe.getUid(), recipe);
        }

        @Override
        public boolean removeRecipe(@Nonnull IMachineRecipe recipe) {
            return this.recipes.remove(recipe.getUid(), recipe);
        }

        @Override
        public IMachineRecipe getRecipeForUid(@Nonnull String uid) {
            return this.recipes.get(uid);
        }

        @Override
        public IMachineRecipe getRecipeForInputs(@Nonnull RecipeLevel machineLevel, @Nonnull String machineName, @Nonnull NNList<MachineRecipeInput> inputs) {
            for (IMachineRecipe recipe : this.recipes.values()) {
                if (!recipe.isRecipe(machineLevel, inputs)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public IMachineRecipe getRecipeForInput(@Nonnull RecipeLevel machineLevel, @Nonnull String machineName, @Nonnull MachineRecipeInput input) {
            for (IMachineRecipe recipe : this.recipes.values()) {
                if (!recipe.isValidInput(machineLevel, input)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        @Nonnull
        public Map<String, IMachineRecipe> getRecipesForMachine() {
            return (Map)NullHelper.notnullJ(Collections.unmodifiableMap(this.recipes), (String)"Collections.unmodifiableMap");
        }
    }

    static interface RecipeGroupHolder<REC extends IMachineRecipe> {
        public void addRecipe(@Nonnull IMachineRecipe var1);

        public boolean removeRecipe(@Nonnull IMachineRecipe var1);

        @Nonnull
        public Map<String, REC> getRecipesForMachine();

        public REC getRecipeForUid(@Nonnull String var1);

        public REC getRecipeForInputs(@Nonnull RecipeLevel var1, @Nonnull String var2, @Nonnull NNList<MachineRecipeInput> var3);

        public REC getRecipeForInput(@Nonnull RecipeLevel var1, @Nonnull String var2, @Nonnull MachineRecipeInput var3);
    }
}

